/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching.version;

import java.util.regex.Pattern;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.time.Time;

public class LastModifiedResourceVersion
implements IResourceVersion {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9]+");

    @Override
    public String getVersion(IStaticCacheableResource resource) {
        IResourceStream stream = resource.getCacheableResourceStream();
        if (stream == null) {
            return null;
        }
        Time lastModified = stream.lastModifiedTime();
        if (lastModified == null) {
            return null;
        }
        return String.valueOf(lastModified.getMilliseconds()).intern();
    }

    @Override
    public Pattern getVersionPattern() {
        return TIMESTAMP_PATTERN;
    }
}

