/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;

public class DateValidator
extends RangeValidator<Date> {
    private static final long serialVersionUID = 1L;
    private String format;

    public static DateValidator range(Date minimum, Date maximum) {
        return new DateValidator(minimum, maximum);
    }

    public static DateValidator range(Date minimum, Date maximum, String format) {
        return new DateValidator(minimum, maximum, format);
    }

    public static DateValidator minimum(Date minimum) {
        return new DateValidator(minimum, null);
    }

    public static DateValidator minimum(Date minimum, String format) {
        return new DateValidator(minimum, null, format);
    }

    public static DateValidator maximum(Date maximum) {
        return new DateValidator(null, maximum);
    }

    public static DateValidator maximum(Date maximum, String format) {
        return new DateValidator(null, maximum, format);
    }

    public DateValidator(Date minimum, Date maximum, String format) {
        super(minimum, maximum);
        this.format = format;
    }

    public DateValidator(Date minimum, Date maximum) {
        this(minimum, maximum, null);
    }

    protected DateValidator() {
    }

    @Override
    protected IValidationError decorate(IValidationError error, IValidatable<Date> validatable) {
        if ((error = super.decorate(error, validatable)) instanceof ValidationError) {
            ValidationError ve = (ValidationError)error;
            ve.setVariable("inputdate", validatable.getValue());
            if (this.format != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                if (this.getMinimum() != null) {
                    ve.setVariable("minimum", sdf.format((Date)this.getMinimum()));
                }
                if (this.getMaximum() != null) {
                    ve.setVariable("maximum", sdf.format((Date)this.getMaximum()));
                }
                ve.setVariable("inputdate", sdf.format(validatable.getValue()));
            }
        }
        return error;
    }
}

