/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.wicket.ApplicationListenerCollection;
import org.apache.wicket.BehaviorInstantiationListenerCollection;
import org.apache.wicket.Component;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.DefaultExceptionMapper;
import org.apache.wicket.DefaultMapperContext;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IInitializer;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.IRequestCycleProvider;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceBundles;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.SessionListenerCollection;
import org.apache.wicket.SharedResources;
import org.apache.wicket.SystemMapper;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.ComponentInitializationListenerCollection;
import org.apache.wicket.application.ComponentInstantiationListenerCollection;
import org.apache.wicket.application.ComponentOnAfterRenderListenerCollection;
import org.apache.wicket.application.ComponentOnBeforeRenderListenerCollection;
import org.apache.wicket.application.ComponentOnConfigureListenerCollection;
import org.apache.wicket.application.HeaderContributorListenerCollection;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.core.util.resource.ClassPathResourceFinder;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.javascript.DefaultJavaScriptCompressor;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.ResourceAggregator;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.markup.html.image.resource.DefaultButtonImageResourceFactory;
import org.apache.wicket.markup.parser.filter.EnclosureHandler;
import org.apache.wicket.markup.parser.filter.InlineEnclosureHandler;
import org.apache.wicket.markup.parser.filter.RelativePathPrefixHandler;
import org.apache.wicket.markup.parser.filter.WicketLinkTagHandler;
import org.apache.wicket.markup.parser.filter.WicketMessageTagHandler;
import org.apache.wicket.markup.resolver.HtmlHeaderResolver;
import org.apache.wicket.markup.resolver.WicketContainerResolver;
import org.apache.wicket.markup.resolver.WicketMessageResolver;
import org.apache.wicket.page.DefaultPageManagerContext;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.RequestLoggerRequestCycleListener;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.response.filter.EmptySrcAttributeCheckFilter;
import org.apache.wicket.session.DefaultPageFactory;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.settings.ApplicationSettings;
import org.apache.wicket.settings.DebugSettings;
import org.apache.wicket.settings.ExceptionSettings;
import org.apache.wicket.settings.FrameworkSettings;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.settings.MarkupSettings;
import org.apache.wicket.settings.PageSettings;
import org.apache.wicket.settings.RequestCycleSettings;
import org.apache.wicket.settings.RequestLoggerSettings;
import org.apache.wicket.settings.ResourceSettings;
import org.apache.wicket.settings.SecuritySettings;
import org.apache.wicket.settings.StoreSettings;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application
implements ISessionStore.UnboundListener,
IEventSink {
    public static final String CONFIGURATION = "configuration";
    private static final Map<String, Application> applicationKeyToApplication = Generics.newHashMap((int)1);
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final String META_INF_WICKET_PATH = File.separatorChar + "META-INF" + File.separatorChar + "wicket" + File.separatorChar;
    private IRequestMapper rootRequestMapper;
    private IConverterLocator converterLocator;
    private final List<IInitializer> initializers = Generics.newArrayList();
    private MetaDataEntry<?>[] metaData;
    private String name;
    private IRequestLogger requestLogger;
    private volatile ISessionStore sessionStore;
    private IPageRendererProvider pageRendererProvider;
    private IRequestCycleProvider requestCycleProvider;
    private Supplier<IExceptionMapper> exceptionMapperProvider;
    private Supplier<ISessionStore> sessionStoreProvider;
    private IHeaderResponseDecorator headerResponseDecorator = headerresponse -> new ResourceAggregator(headerresponse);
    private final ComponentOnBeforeRenderListenerCollection componentPreOnBeforeRenderListeners = new ComponentOnBeforeRenderListenerCollection();
    private final ComponentOnBeforeRenderListenerCollection componentPostOnBeforeRenderListeners = new ComponentOnBeforeRenderListenerCollection();
    private final ComponentOnAfterRenderListenerCollection componentOnAfterRenderListeners = new ComponentOnAfterRenderListenerCollection();
    private final RequestCycleListenerCollection requestCycleListeners = new RequestCycleListenerCollection();
    private final ApplicationListenerCollection applicationListeners = new ApplicationListenerCollection();
    private final SessionListenerCollection sessionListeners = new SessionListenerCollection();
    private final ComponentInstantiationListenerCollection componentInstantiationListeners = new ComponentInstantiationListenerCollection();
    private final ComponentInitializationListenerCollection componentInitializationListeners = new ComponentInitializationListenerCollection();
    private final ComponentOnConfigureListenerCollection componentOnConfigureListeners = new ComponentOnConfigureListenerCollection();
    private final HeaderContributorListenerCollection headerContributorListeners = new HeaderContributorListenerCollection();
    private final BehaviorInstantiationListenerCollection behaviorInstantiationListeners = new BehaviorInstantiationListenerCollection();
    private ApplicationSettings applicationSettings;
    private JavaScriptLibrarySettings javaScriptLibrarySettings;
    private DebugSettings debugSettings;
    private ExceptionSettings exceptionSettings;
    private FrameworkSettings frameworkSettings;
    private MarkupSettings markupSettings;
    private PageSettings pageSettings;
    private RequestCycleSettings requestCycleSettings;
    private RequestLoggerSettings requestLoggerSettings;
    private ResourceSettings resourceSettings;
    private SecuritySettings securitySettings;
    private StoreSettings storeSettings;
    private boolean settingsAccessible;
    private volatile IPageManager pageManager;
    private IPageManagerProvider pageManagerProvider;
    private final IPageManagerContext pageManagerContext = new DefaultPageManagerContext();
    private ResourceReferenceRegistry resourceReferenceRegistry;
    private SharedResources sharedResources;
    private ResourceBundles resourceBundles;
    private IPageFactory pageFactory;
    private IMapperContext encoderContext;

    public static boolean exists() {
        return ThreadContext.getApplication() != null;
    }

    public static Application get() {
        Application application = ThreadContext.getApplication();
        if (application == null) {
            throw new WicketRuntimeException("There is no application attached to current thread " + Thread.currentThread().getName());
        }
        return application;
    }

    public static Application get(String applicationKey) {
        return applicationKeyToApplication.get(applicationKey);
    }

    public static Set<String> getApplicationKeys() {
        return Collections.unmodifiableSet(applicationKeyToApplication.keySet());
    }

    public Application() {
        this.getComponentInstantiationListeners().add(new IComponentInstantiationListener(){

            @Override
            public void onInstantiation(Component component) {
                Class<?> cl = component.getClass();
                if (!Session.get().getAuthorizationStrategy().isInstantiationAuthorized(cl)) {
                    Application.this.getSecuritySettings().getUnauthorizedComponentInstantiationListener().onUnauthorizedInstantiation(component);
                }
            }
        });
    }

    public final void configure() {
        switch (this.getConfigurationType()) {
            case DEVELOPMENT: {
                this.getResourceSettings().setResourcePollFrequency(Duration.ONE_SECOND);
                this.getResourceSettings().setJavaScriptCompressor(null);
                this.getResourceSettings().setUseMinifiedResources(false);
                this.getMarkupSettings().setStripWicketTags(false);
                this.getExceptionSettings().setUnexpectedExceptionDisplay(ExceptionSettings.SHOW_EXCEPTION_PAGE);
                this.getDebugSettings().setComponentUseCheck(true);
                this.getDebugSettings().setAjaxDebugModeEnabled(true);
                this.getDebugSettings().setDevelopmentUtilitiesEnabled(true);
                this.getRequestCycleSettings().addResponseFilter(EmptySrcAttributeCheckFilter.INSTANCE);
                break;
            }
            case DEPLOYMENT: {
                this.getResourceSettings().setResourcePollFrequency(null);
                this.getResourceSettings().setJavaScriptCompressor(new DefaultJavaScriptCompressor());
                this.getMarkupSettings().setStripWicketTags(true);
                this.getExceptionSettings().setUnexpectedExceptionDisplay(ExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
                this.getDebugSettings().setComponentUseCheck(false);
                this.getDebugSettings().setAjaxDebugModeEnabled(false);
                this.getDebugSettings().setDevelopmentUtilitiesEnabled(false);
            }
        }
    }

    public abstract String getApplicationKey();

    public abstract RuntimeConfigurationType getConfigurationType();

    public abstract Class<? extends Page> getHomePage();

    public final IConverterLocator getConverterLocator() {
        return this.converterLocator;
    }

    public final synchronized <T> T getMetaData(MetaDataKey<T> key) {
        return key.get(this.metaData);
    }

    public final String getName() {
        return this.name;
    }

    public final IRequestLogger getRequestLogger() {
        if (this.getRequestLoggerSettings().isRequestLoggerEnabled()) {
            if (this.requestLogger == null) {
                this.requestLogger = this.newRequestLogger();
            }
        } else {
            this.requestLogger = null;
        }
        return this.requestLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            Application application = this;
            synchronized (application) {
                if (this.sessionStore == null) {
                    this.sessionStore = this.sessionStoreProvider.get();
                    this.sessionStore.registerUnboundListener(this);
                }
            }
        }
        return this.sessionStore;
    }

    @Override
    public void sessionUnbound(String sessionId) {
        this.getSessionListeners().onUnbound(sessionId);
    }

    public void logEventTarget(IRequestHandler target) {
    }

    public void logResponseTarget(IRequestHandler requestTarget) {
    }

    public abstract Session newSession(Request var1, Response var2);

    public final synchronized <T> Application setMetaData(MetaDataKey<T> key, Object object) {
        this.metaData = key.set(this.metaData, object);
        return this;
    }

    private void addInitializer(String className) {
        IInitializer initializer = (IInitializer)WicketObjects.newInstance(className);
        if (initializer != null) {
            this.initializers.add(initializer);
        }
    }

    private void destroyInitializers() {
        for (IInitializer initializer : this.initializers) {
            log.info("[{}] destroy: {}", (Object)this.getName(), (Object)initializer);
            initializer.destroy(this);
        }
    }

    private void initInitializers() {
        for (IInitializer initializer : this.initializers) {
            log.info("[{}] init: {}", (Object)this.getName(), (Object)initializer);
            initializer.init(this);
        }
        ServiceLoader<IInitializer> serviceLoaderInitializers = ServiceLoader.load(IInitializer.class);
        for (IInitializer serviceLoaderInitializer : serviceLoaderInitializers) {
            log.info("[{}] init: {}", (Object)this.getName(), (Object)serviceLoaderInitializer);
            serviceLoaderInitializer.init(this);
            this.initializers.add(serviceLoaderInitializer);
        }
    }

    private void load(Properties properties) {
        this.addInitializer(properties.getProperty("initializer"));
        this.addInitializer(properties.getProperty(this.getName() + "-initializer"));
    }

    protected void onDestroy() {
    }

    protected void init() {
    }

    public void internalDestroy() {
        this.applicationListeners.onBeforeDestroyed(this);
        IDetachListener detachListener = this.getFrameworkSettings().getDetachListener();
        if (detachListener != null) {
            detachListener.onDestroyListener();
        }
        PropertyResolver.destroy(this);
        MarkupFactory markupFactory = this.getMarkupSettings().getMarkupFactory();
        if (markupFactory.hasMarkupCache()) {
            markupFactory.getMarkupCache().shutdown();
        }
        this.onDestroy();
        this.destroyInitializers();
        this.internalGetPageManager().destroy();
        this.getSessionStore().destroy();
        applicationKeyToApplication.remove(this.getApplicationKey());
    }

    protected void internalInit() {
        this.settingsAccessible = true;
        PageSettings pageSettings = this.getPageSettings();
        pageSettings.addComponentResolver(new HtmlHeaderResolver());
        pageSettings.addComponentResolver(new WicketLinkTagHandler());
        pageSettings.addComponentResolver(new WicketMessageResolver());
        pageSettings.addComponentResolver(new RelativePathPrefixHandler());
        pageSettings.addComponentResolver(new EnclosureHandler());
        pageSettings.addComponentResolver(new InlineEnclosureHandler());
        pageSettings.addComponentResolver(new WicketMessageTagHandler());
        pageSettings.addComponentResolver(new WicketContainerResolver());
        this.getResourceSettings().getResourceFinders().add(new ClassPathResourceFinder(""));
        this.getResourceSettings().addResourceFactory("buttonFactory", new DefaultButtonImageResourceFactory());
        String applicationKey = this.getApplicationKey();
        applicationKeyToApplication.put(applicationKey, this);
        this.converterLocator = this.newConverterLocator();
        this.setPageManagerProvider(new DefaultPageManagerProvider(this));
        this.resourceReferenceRegistry = this.newResourceReferenceRegistry();
        this.sharedResources = this.newSharedResources(this.resourceReferenceRegistry);
        this.resourceBundles = this.newResourceBundles(this.resourceReferenceRegistry);
        this.setRootRequestMapper((IRequestMapper)new SystemMapper(this));
        this.pageFactory = this.newPageFactory();
        this.requestCycleProvider = context -> new RequestCycle((RequestCycleContext)context);
        this.exceptionMapperProvider = () -> new DefaultExceptionMapper();
        this.getRequestCycleListeners().add(new RequestLoggerRequestCycleListener());
    }

    public Supplier<IExceptionMapper> getExceptionMapperProvider() {
        return this.exceptionMapperProvider;
    }

    public final Supplier<ISessionStore> getSessionStoreProvider() {
        return this.sessionStoreProvider;
    }

    public final Application setSessionStoreProvider(Supplier<ISessionStore> sessionStoreProvider) {
        this.sessionStoreProvider = (Supplier)Args.notNull(sessionStoreProvider, (String)"sessionStoreProvider");
        this.sessionStore = null;
        return this;
    }

    protected IConverterLocator newConverterLocator() {
        return new ConverterLocator();
    }

    protected IRequestLogger newRequestLogger() {
        return new RequestLogger();
    }

    public final ICompoundRequestMapper getRootRequestMapperAsCompound() {
        IRequestMapper root = this.getRootRequestMapper();
        if (!(root instanceof ICompoundRequestMapper)) {
            root = new SystemMapper(this).add(root);
            this.setRootRequestMapper(root);
        }
        return (ICompoundRequestMapper)root;
    }

    public final IRequestMapper getRootRequestMapper() {
        return this.rootRequestMapper;
    }

    public final Application setRootRequestMapper(IRequestMapper rootRequestMapper) {
        this.rootRequestMapper = rootRequestMapper;
        return this;
    }

    public final void initApplication() {
        if (this.name == null) {
            throw new IllegalStateException("setName must be called before initApplication");
        }
        this.internalInit();
        this.initInitializers();
        this.init();
        this.applicationListeners.onAfterInitialized(this);
        this.validateInit();
    }

    protected void validateInit() {
        if (this.getPageRendererProvider() == null) {
            throw new IllegalStateException("An instance of IPageRendererProvider has not yet been set on this Application. @see Application#setPageRendererProvider");
        }
        if (this.getSessionStoreProvider() == null) {
            throw new IllegalStateException("An instance of ISessionStoreProvider has not yet been set on this Application. @see Application#setSessionStoreProvider");
        }
        if (this.getPageManagerProvider() == null) {
            throw new IllegalStateException("An instance of IPageManagerProvider has not yet been set on this Application. @see Application#setPageManagerProvider");
        }
    }

    public final void setName(String name) {
        Args.notEmpty((CharSequence)name, (String)"name");
        if (this.name != null) {
            throw new IllegalStateException("Application name can only be set once.");
        }
        if (applicationKeyToApplication.get(name) != null) {
            throw new IllegalStateException("Application with name '" + name + "' already exists.'");
        }
        this.name = name;
        applicationKeyToApplication.put(name, this);
    }

    public String getMimeType(String fileName) {
        return URLConnection.getFileNameMap().getContentTypeFor(fileName);
    }

    @Override
    public void onEvent(IEvent<?> event) {
    }

    public final HeaderContributorListenerCollection getHeaderContributorListeners() {
        return this.headerContributorListeners;
    }

    public final List<IInitializer> getInitializers() {
        return Collections.unmodifiableList(this.initializers);
    }

    public final ApplicationListenerCollection getApplicationListeners() {
        return this.applicationListeners;
    }

    public final SessionListenerCollection getSessionListeners() {
        return this.sessionListeners;
    }

    public final BehaviorInstantiationListenerCollection getBehaviorInstantiationListeners() {
        return this.behaviorInstantiationListeners;
    }

    public final ComponentInstantiationListenerCollection getComponentInstantiationListeners() {
        return this.componentInstantiationListeners;
    }

    public final ComponentInitializationListenerCollection getComponentInitializationListeners() {
        return this.componentInitializationListeners;
    }

    public final ComponentOnConfigureListenerCollection getComponentOnConfigureListeners() {
        return this.componentOnConfigureListeners;
    }

    public final ComponentOnBeforeRenderListenerCollection getComponentPreOnBeforeRenderListeners() {
        return this.componentPreOnBeforeRenderListeners;
    }

    public final ComponentOnBeforeRenderListenerCollection getComponentPostOnBeforeRenderListeners() {
        return this.componentPostOnBeforeRenderListeners;
    }

    public final ComponentOnAfterRenderListenerCollection getComponentOnAfterRenderListeners() {
        return this.componentOnAfterRenderListeners;
    }

    public RequestCycleListenerCollection getRequestCycleListeners() {
        return this.requestCycleListeners;
    }

    public final ApplicationSettings getApplicationSettings() {
        this.checkSettingsAvailable();
        if (this.applicationSettings == null) {
            this.applicationSettings = new ApplicationSettings();
        }
        return this.applicationSettings;
    }

    public final Application setApplicationSettings(ApplicationSettings applicationSettings) {
        this.applicationSettings = applicationSettings;
        return this;
    }

    public final JavaScriptLibrarySettings getJavaScriptLibrarySettings() {
        this.checkSettingsAvailable();
        if (this.javaScriptLibrarySettings == null) {
            this.javaScriptLibrarySettings = new JavaScriptLibrarySettings();
        }
        return this.javaScriptLibrarySettings;
    }

    public final Application setJavaScriptLibrarySettings(JavaScriptLibrarySettings javaScriptLibrarySettings) {
        this.javaScriptLibrarySettings = javaScriptLibrarySettings;
        return this;
    }

    public final DebugSettings getDebugSettings() {
        this.checkSettingsAvailable();
        if (this.debugSettings == null) {
            this.debugSettings = new DebugSettings();
        }
        return this.debugSettings;
    }

    public final Application setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
        return this;
    }

    public final ExceptionSettings getExceptionSettings() {
        this.checkSettingsAvailable();
        if (this.exceptionSettings == null) {
            this.exceptionSettings = new ExceptionSettings();
        }
        return this.exceptionSettings;
    }

    public final Application setExceptionSettings(ExceptionSettings exceptionSettings) {
        this.exceptionSettings = exceptionSettings;
        return this;
    }

    public final FrameworkSettings getFrameworkSettings() {
        this.checkSettingsAvailable();
        if (this.frameworkSettings == null) {
            this.frameworkSettings = new FrameworkSettings(this);
        }
        return this.frameworkSettings;
    }

    public final Application setFrameworkSettings(FrameworkSettings frameworkSettings) {
        this.frameworkSettings = frameworkSettings;
        return this;
    }

    public final PageSettings getPageSettings() {
        this.checkSettingsAvailable();
        if (this.pageSettings == null) {
            this.pageSettings = new PageSettings();
        }
        return this.pageSettings;
    }

    public final Application setPageSettings(PageSettings pageSettings) {
        this.pageSettings = pageSettings;
        return this;
    }

    public final RequestCycleSettings getRequestCycleSettings() {
        this.checkSettingsAvailable();
        if (this.requestCycleSettings == null) {
            this.requestCycleSettings = new RequestCycleSettings();
        }
        return this.requestCycleSettings;
    }

    public final Application setRequestCycleSettings(RequestCycleSettings requestCycleSettings) {
        this.requestCycleSettings = requestCycleSettings;
        return this;
    }

    public MarkupSettings getMarkupSettings() {
        this.checkSettingsAvailable();
        if (this.markupSettings == null) {
            this.markupSettings = new MarkupSettings();
        }
        return this.markupSettings;
    }

    public final Application setMarkupSettings(MarkupSettings markupSettings) {
        this.markupSettings = markupSettings;
        return this;
    }

    public final RequestLoggerSettings getRequestLoggerSettings() {
        this.checkSettingsAvailable();
        if (this.requestLoggerSettings == null) {
            this.requestLoggerSettings = new RequestLoggerSettings();
        }
        return this.requestLoggerSettings;
    }

    public final Application setRequestLoggerSettings(RequestLoggerSettings requestLoggerSettings) {
        this.requestLoggerSettings = requestLoggerSettings;
        return this;
    }

    public final ResourceSettings getResourceSettings() {
        this.checkSettingsAvailable();
        if (this.resourceSettings == null) {
            this.resourceSettings = new ResourceSettings(this);
        }
        return this.resourceSettings;
    }

    public final Application setResourceSettings(ResourceSettings resourceSettings) {
        this.resourceSettings = resourceSettings;
        return this;
    }

    public final SecuritySettings getSecuritySettings() {
        this.checkSettingsAvailable();
        if (this.securitySettings == null) {
            this.securitySettings = new SecuritySettings();
        }
        return this.securitySettings;
    }

    public final Application setSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public final StoreSettings getStoreSettings() {
        this.checkSettingsAvailable();
        if (this.storeSettings == null) {
            this.storeSettings = new StoreSettings(this);
        }
        return this.storeSettings;
    }

    public final Application setStoreSettings(StoreSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    private void checkSettingsAvailable() {
        if (!this.settingsAccessible) {
            throw new WicketRuntimeException("Use Application.init() method for configuring your application object");
        }
    }

    public final IPageManagerProvider getPageManagerProvider() {
        return this.pageManagerProvider;
    }

    public final Application setPageManagerProvider(IPageManagerProvider provider) {
        this.pageManagerProvider = provider;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IPageManager internalGetPageManager() {
        if (this.pageManager == null) {
            Application application = this;
            synchronized (application) {
                if (this.pageManager == null) {
                    this.pageManager = (IPageManager)this.pageManagerProvider.apply(this.getPageManagerContext());
                }
            }
        }
        return this.pageManager;
    }

    protected IPageManagerContext getPageManagerContext() {
        return this.pageManagerContext;
    }

    public final IPageRendererProvider getPageRendererProvider() {
        return this.pageRendererProvider;
    }

    public final Application setPageRendererProvider(IPageRendererProvider pageRendererProvider) {
        Args.notNull((Object)pageRendererProvider, (String)"pageRendererProvider");
        this.pageRendererProvider = pageRendererProvider;
        return this;
    }

    protected ResourceReferenceRegistry newResourceReferenceRegistry() {
        return new ResourceReferenceRegistry();
    }

    public final ResourceReferenceRegistry getResourceReferenceRegistry() {
        return this.resourceReferenceRegistry;
    }

    protected SharedResources newSharedResources(ResourceReferenceRegistry registry) {
        return new SharedResources(registry);
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    protected ResourceBundles newResourceBundles(ResourceReferenceRegistry registry) {
        return new ResourceBundles(registry);
    }

    public ResourceBundles getResourceBundles() {
        return this.resourceBundles;
    }

    protected IPageFactory newPageFactory() {
        return new DefaultPageFactory();
    }

    public final IPageFactory getPageFactory() {
        return this.pageFactory;
    }

    public final IMapperContext getMapperContext() {
        if (this.encoderContext == null) {
            this.encoderContext = this.newMapperContext();
        }
        return this.encoderContext;
    }

    protected IMapperContext newMapperContext() {
        return new DefaultMapperContext(this);
    }

    public Session fetchCreateAndSetSession(RequestCycle requestCycle) {
        Args.notNull((Object)requestCycle, (String)"requestCycle");
        Session session = this.getSessionStore().lookup(requestCycle.getRequest());
        if (session == null) {
            session = this.newSession(requestCycle.getRequest(), requestCycle.getResponse());
            ThreadContext.setSession(session);
            this.internalGetPageManager().newSessionCreated();
            this.sessionListeners.onCreated(session);
        } else {
            ThreadContext.setSession(session);
        }
        return session;
    }

    public final IRequestCycleProvider getRequestCycleProvider() {
        return this.requestCycleProvider;
    }

    public final Application setRequestCycleProvider(IRequestCycleProvider requestCycleProvider) {
        this.requestCycleProvider = requestCycleProvider;
        return this;
    }

    public final RequestCycle createRequestCycle(Request request, Response response) {
        RequestCycleContext context = new RequestCycleContext(request, response, this.getRootRequestMapper(), this.getExceptionMapperProvider().get());
        RequestCycle requestCycle = (RequestCycle)this.getRequestCycleProvider().apply(context);
        requestCycle.getListeners().add(this.requestCycleListeners);
        requestCycle.getListeners().add(new IRequestCycleListener(){

            @Override
            public void onDetach(RequestCycle requestCycle) {
                IRequestLogger requestLogger;
                if (Session.exists()) {
                    Session.get().getPageManager().commitRequest();
                }
                if (Application.exists() && (requestLogger = Application.get().getRequestLogger()) != null) {
                    requestLogger.requestTime(System.currentTimeMillis() - requestCycle.getStartTime());
                }
            }
        });
        return requestCycle;
    }

    public final Application setHeaderResponseDecorator(IHeaderResponseDecorator headerResponseDecorator) {
        Args.notNull((Object)headerResponseDecorator, (String)"headerResponseDecorator");
        this.headerResponseDecorator = headerResponseDecorator;
        return this;
    }

    public final IHeaderResponse decorateHeaderResponse(IHeaderResponse response) {
        return this.headerResponseDecorator.decorate(response);
    }

    public final boolean usesDevelopmentConfig() {
        return RuntimeConfigurationType.DEVELOPMENT.equals((Object)this.getConfigurationType());
    }

    public final boolean usesDeploymentConfig() {
        return RuntimeConfigurationType.DEPLOYMENT.equals((Object)this.getConfigurationType());
    }
}

