/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.File;
import org.apache.wicket.Application;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.PageStoreManager;
import org.apache.wicket.pageStore.AsynchronousDataStore;
import org.apache.wicket.pageStore.AsynchronousPageStore;
import org.apache.wicket.pageStore.DefaultPageStore;
import org.apache.wicket.pageStore.DiskDataStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.StoreSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class DefaultPageManagerProvider
implements IPageManagerProvider {
    protected final Application application;

    public DefaultPageManagerProvider(Application application) {
        this.application = (Application)Args.notNull((Object)application, (String)"application");
    }

    @Override
    public IPageManager apply(IPageManagerContext pageManagerContext) {
        IPageStore pageStore;
        IDataStore dataStore = this.newDataStore();
        StoreSettings storeSettings = this.getStoreSettings();
        if (dataStore.canBeAsynchronous() && storeSettings.isAsynchronous()) {
            int capacity = storeSettings.getAsynchronousQueueCapacity();
            pageStore = this.newPageStore(dataStore = new AsynchronousDataStore(dataStore, capacity));
            if (pageStore.canBeAsynchronous()) {
                pageStore = new AsynchronousPageStore(pageStore, capacity);
            }
        } else {
            pageStore = this.newPageStore(dataStore);
        }
        return new PageStoreManager(this.application.getName(), pageStore, pageManagerContext);
    }

    protected IPageStore newPageStore(IDataStore dataStore) {
        int inmemoryCacheSize = this.getStoreSettings().getInmemoryCacheSize();
        ISerializer pageSerializer = this.application.getFrameworkSettings().getSerializer();
        return new DefaultPageStore(pageSerializer, dataStore, inmemoryCacheSize);
    }

    protected IDataStore newDataStore() {
        StoreSettings storeSettings = this.getStoreSettings();
        Bytes maxSizePerSession = storeSettings.getMaxSizePerSession();
        File fileStoreFolder = storeSettings.getFileStoreFolder();
        return new DiskDataStore(this.application.getName(), fileStoreFolder, maxSizePerSession);
    }

    StoreSettings getStoreSettings() {
        return this.application.getStoreSettings();
    }
}

