/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.ContextParamWebApplicationFactory;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebApplicationFactoryCreationException;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.file.WebXmlFile;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WicketFilter.class);
    public static final String FILTER_MAPPING_PARAM = "filterMappingUrlPattern";
    public static final String APP_FACT_PARAM = "applicationFactoryClassName";
    public static final String IGNORE_PATHS_PARAM = "ignorePaths";
    private WebApplication application;
    private IWebApplicationFactory applicationFactory;
    private FilterConfig filterConfig;
    private String filterPath;
    private int filterPathLength = -1;
    private final Set<String> ignorePaths = new HashSet<String>();
    private boolean isServlet = false;

    public WicketFilter() {
    }

    public WicketFilter(WebApplication application) {
        this.application = (WebApplication)Args.notNull((Object)application, (String)"application");
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRequest(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean res;
        block16: {
            ThreadContext previousThreadContext = ThreadContext.detach();
            res = true;
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = this.getClassLoader();
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            try {
                String filterPath;
                if (previousClassLoader != newClassLoader) {
                    Thread.currentThread().setContextClassLoader(newClassLoader);
                }
                if ((filterPath = this.getFilterPath(httpServletRequest)) == null) {
                    throw new IllegalStateException("filter path was not configured");
                }
                if (this.shouldIgnorePath(httpServletRequest)) {
                    log.debug("Ignoring request {}", (Object)httpServletRequest.getRequestURL());
                    if (chain != null) {
                        chain.doFilter(request, response);
                    }
                    boolean bl = false;
                    return bl;
                }
                if ("OPTIONS".equalsIgnoreCase(httpServletRequest.getMethod())) {
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setHeader("Allow", "GET,POST,OPTIONS,PUT,HEAD,PATCH,DELETE,TRACE");
                    httpServletResponse.setHeader("Content-Length", "0");
                    boolean bl = true;
                    return bl;
                }
                String redirectURL = this.checkIfRedirectRequired(httpServletRequest);
                if (redirectURL == null) {
                    ThreadContext.setApplication(this.application);
                    WebRequest webRequest = this.application.createWebRequest(httpServletRequest, filterPath);
                    WebResponse webResponse = this.application.createWebResponse(webRequest, httpServletResponse);
                    RequestCycle requestCycle = this.application.createRequestCycle((Request)webRequest, (Response)webResponse);
                    res = this.processRequestCycle(requestCycle, webResponse, httpServletRequest, httpServletResponse, chain);
                    break block16;
                }
                if (!Strings.isEmpty((CharSequence)httpServletRequest.getQueryString())) {
                    redirectURL = redirectURL + "?" + httpServletRequest.getQueryString();
                }
                try {
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(redirectURL));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                ThreadContext.restore(previousThreadContext);
                if (newClassLoader != previousClassLoader) {
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                }
                if (response.isCommitted() && !httpServletRequest.isAsyncStarted()) {
                    response.flushBuffer();
                }
            }
        }
        return res;
    }

    protected boolean processRequestCycle(RequestCycle requestCycle, WebResponse webResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws IOException, ServletException {
        boolean res = true;
        if (requestCycle.processRequestAndDetach()) {
            webResponse.flush();
        } else {
            if (chain != null) {
                chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            res = false;
        }
        return res;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.processRequest(request, response, chain);
    }

    protected IWebApplicationFactory getApplicationFactory() {
        String appFactoryClassName = this.filterConfig.getInitParameter(APP_FACT_PARAM);
        if (appFactoryClassName == null) {
            return new ContextParamWebApplicationFactory();
        }
        try {
            Class<?> factoryClass = Class.forName(appFactoryClassName, false, Thread.currentThread().getContextClassLoader());
            return (IWebApplicationFactory)factoryClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new WicketRuntimeException("Application factory class " + appFactoryClassName + " must implement IWebApplicationFactory");
        }
        catch (ClassNotFoundException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (InstantiationException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
        catch (SecurityException e) {
            throw new WebApplicationFactoryCreationException(appFactoryClassName, e);
        }
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.init(false, filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.isServlet = isServlet;
        this.initIgnorePaths(filterConfig);
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = this.getClassLoader();
        try {
            if (previousClassLoader != newClassLoader) {
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            if (this.application == null) {
                this.applicationFactory = this.getApplicationFactory();
                this.application = this.applicationFactory.createApplication(this);
            }
            if (this.application.getName() == null) {
                this.application.setName(filterConfig.getFilterName());
            }
            this.application.setWicketFilter(this);
            String configureFilterPath = this.getFilterPath();
            if (configureFilterPath == null) {
                configureFilterPath = this.getFilterPathFromConfig(filterConfig);
                if (configureFilterPath == null && (configureFilterPath = this.getFilterPathFromWebXml(isServlet, filterConfig)) == null) {
                    configureFilterPath = this.getFilterPathFromAnnotation(isServlet);
                }
                if (configureFilterPath != null) {
                    this.setFilterPath(configureFilterPath);
                }
            }
            if (this.getFilterPath() == null) {
                log.warn("Unable to determine filter path from filter init-param, web.xml, or servlet 3.0 annotations. Assuming user will set filter path manually by calling setFilterPath(String)");
            }
            ThreadContext.setApplication(this.application);
            try {
                this.application.initApplication();
                this.application.logStarted();
            }
            finally {
                ThreadContext.detach();
            }
        }
        catch (Exception e) {
            log.error(String.format("The initialization of an application with name '%s' has failed.", filterConfig.getFilterName()), (Throwable)e);
            try {
                this.destroy();
            }
            catch (Exception destroyException) {
                log.error("Unable to destroy after initialization failure", (Throwable)destroyException);
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            if (newClassLoader != previousClassLoader) {
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
        }
    }

    protected String getFilterPathFromAnnotation(boolean isServlet) {
        String[] patterns = null;
        if (isServlet) {
            WebServlet servlet = this.getClass().getAnnotation(WebServlet.class);
            if (servlet != null) {
                patterns = servlet.urlPatterns().length > 0 ? servlet.urlPatterns() : servlet.value();
            }
        } else {
            WebFilter filter = this.getClass().getAnnotation(WebFilter.class);
            if (filter != null) {
                patterns = filter.urlPatterns().length > 0 ? filter.urlPatterns() : filter.value();
            }
        }
        if (patterns != null && patterns.length > 0) {
            String pattern = patterns[0];
            if (patterns.length > 1) {
                log.warn("Multiple url patterns defined for Wicket filter/servlet, using the first: {}", (Object)pattern);
            }
            if ("/*".equals(pattern)) {
                pattern = "";
            }
            if (pattern.endsWith("*")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            return pattern;
        }
        return null;
    }

    protected String getFilterPathFromWebXml(boolean isServlet, FilterConfig filterConfig) {
        return new WebXmlFile().getUniqueFilterPath(isServlet, filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected String getFilterPath(HttpServletRequest request) {
        return this.filterPath;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    protected String getFilterPathFromConfig(FilterConfig filterConfig) {
        String result = filterConfig.getInitParameter(FILTER_MAPPING_PARAM);
        if (result != null) {
            if (result.equals("/*")) {
                result = "";
            } else {
                if (!result.startsWith("/") || !result.endsWith("/*")) {
                    throw new WicketRuntimeException("Your filterMappingUrlPattern must start with \"/\" and end with \"/*\". It is: " + result);
                }
                result = result.substring(1, result.length() - 1);
            }
        }
        return result;
    }

    public void destroy() {
        if (this.application != null) {
            try {
                ThreadContext.setApplication(this.application);
                this.application.internalDestroy();
            }
            finally {
                ThreadContext.detach();
                this.application = null;
            }
        }
        if (this.applicationFactory != null) {
            try {
                this.applicationFactory.destroy(this);
            }
            finally {
                this.applicationFactory = null;
            }
        }
    }

    private String checkIfRedirectRequired(HttpServletRequest request) {
        return this.checkIfRedirectRequired(request.getRequestURI(), request.getContextPath());
    }

    protected final String checkIfRedirectRequired(String requestURI, String contextPath) {
        int homePathLength;
        int uriLength = requestURI.indexOf(59);
        if (uriLength == -1) {
            uriLength = requestURI.length();
        }
        if (uriLength != (homePathLength = contextPath.length() + (this.filterPathLength > 0 ? 1 + this.filterPathLength : 0))) {
            return null;
        }
        String uri = Strings.stripJSessionId((String)requestURI);
        String homePageUri = contextPath + '/' + this.getFilterPath();
        if (homePageUri.endsWith("/")) {
            homePageUri = homePageUri.substring(0, homePageUri.length() - 1);
        }
        if (uri.equals(homePageUri)) {
            uri = uri + "/";
            return uri;
        }
        return null;
    }

    public final void setFilterPath(String filterPath) {
        if (this.filterPath != null) {
            throw new IllegalStateException("Filter path is write-once. You can not change it. Current value='" + filterPath + '\'');
        }
        if (filterPath != null) {
            this.filterPathLength = (filterPath = WicketFilter.canonicaliseFilterPath(filterPath)).endsWith("/") ? filterPath.length() - 1 : filterPath.length();
        }
        this.filterPath = filterPath;
    }

    public String getRelativePath(HttpServletRequest request) {
        String filterPath;
        String path = Strings.stripJSessionId((String)request.getRequestURI());
        String contextPath = request.getContextPath();
        path = path.substring(contextPath.length());
        if (this.isServlet) {
            String servletPath = request.getServletPath();
            path = path.substring(servletPath.length());
        }
        if (path.length() > 0) {
            path = path.substring(1);
        }
        if (!path.startsWith(filterPath = this.getFilterPath()) && filterPath.equals(path + "/")) {
            path = path + "/";
        }
        if (path.startsWith(filterPath)) {
            path = path.substring(filterPath.length());
        }
        return path;
    }

    protected WebApplication getApplication() {
        return this.application;
    }

    private boolean shouldIgnorePath(HttpServletRequest request) {
        String relativePath;
        boolean ignore = false;
        if (this.ignorePaths.size() > 0 && !Strings.isEmpty((CharSequence)(relativePath = this.getRelativePath(request)))) {
            for (String path : this.ignorePaths) {
                if (!relativePath.startsWith(path)) continue;
                ignore = true;
                break;
            }
        }
        return ignore;
    }

    private void initIgnorePaths(FilterConfig filterConfig) {
        String paths = filterConfig.getInitParameter(IGNORE_PATHS_PARAM);
        if (!Strings.isEmpty((CharSequence)paths)) {
            String[] parts;
            for (String path : parts = Strings.split((String)paths, (char)',')) {
                if ((path = path.trim()).startsWith("/")) {
                    path = path.substring(1);
                }
                this.ignorePaths.add(path);
            }
        }
    }

    static String canonicaliseFilterPath(String filterPath) {
        int o;
        char c;
        int beginIndex;
        if (Strings.isEmpty((CharSequence)filterPath)) {
            return filterPath;
        }
        int endIndex = filterPath.length();
        for (beginIndex = 0; beginIndex < endIndex && (c = filterPath.charAt(beginIndex)) == '/'; ++beginIndex) {
        }
        for (int i = o = beginIndex; i < endIndex; ++i) {
            char c2 = filterPath.charAt(i);
            if (c2 == '/') continue;
            o = i;
        }
        filterPath = o < endIndex ? filterPath.substring(beginIndex, ++o) : filterPath.substring(beginIndex) + '/';
        if (filterPath.equals("/")) {
            return "";
        }
        return filterPath;
    }
}

