/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxButton
extends Button {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AjaxButton.class);
    private final Form<?> form;

    public AjaxButton(String id) {
        this(id, null, null);
    }

    public AjaxButton(String id, IModel<String> model) {
        this(id, model, null);
    }

    public AjaxButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.form = form;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxFormSubmitBehavior("click"));
    }

    protected AjaxFormSubmitBehavior newAjaxFormSubmitBehavior(String event) {
        return new AjaxFormSubmitBehavior(this.form, event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onSubmit(target);
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onAfterSubmit(target);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxButton.this.onError(target);
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setPreventDefault(true);
                AjaxButton.this.updateAjaxAttributes(attributes);
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxButton.this.getDefaultFormProcessing();
            }

            @Override
            public boolean getStatelessHint(Component component) {
                return AjaxButton.this.getStatelessHint();
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    public Form<?> getForm() {
        if (this.form != null) {
            return this.form;
        }
        return super.getForm();
    }

    @Override
    public final void onSubmit() {
        logger.warn("unexpected invocation of #onSubmit() on {}", (Object)this);
    }

    @Override
    public final void onAfterSubmit() {
        logger.warn("unexpected invocation of #onAfterSubmit() on {}", (Object)this);
    }

    @Override
    public final void onError() {
        logger.warn("unexpected invocation of #onError() on {}", (Object)this);
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

