/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class AjaxFormSubmitBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private Form<?> __form;
    private boolean defaultProcessing = true;

    public AjaxFormSubmitBehavior(String event) {
        this(null, event);
    }

    public AjaxFormSubmitBehavior(Form<?> form, String event) {
        super(event);
        this.__form = form;
        if (form != null) {
            form.setOutputMarkupId(true);
        }
    }

    public final Form<?> getForm() {
        if (this.__form == null) {
            this.__form = this.findForm();
            if (this.__form == null) {
                throw new IllegalStateException("form was not specified in the constructor and cannot be found in the hierarchy of the component this behavior is attached to: Component=" + this.getComponent().toString(false));
            }
        }
        return this.__form;
    }

    private IFormSubmittingComponent getFormSubmittingComponent() {
        IFormSubmittingComponent submittingComponent = null;
        Component component = this.getComponent();
        if (component instanceof IFormSubmittingComponent) {
            submittingComponent = (IFormSubmittingComponent)((Object)component);
        }
        return submittingComponent;
    }

    protected Form<?> findForm() {
        Component component = this.getComponent();
        if (component instanceof Form) {
            return (Form)component;
        }
        return component.findParent(Form.class);
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        IFormSubmittingComponent submittingComponent;
        super.updateAjaxAttributes(attributes);
        Form<?> form = this.getForm();
        attributes.setFormId(form.getMarkupId());
        String formMethod = form.getMarkupAttributes().getString("method");
        if (formMethod == null || "POST".equalsIgnoreCase(formMethod)) {
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }
        if (form.getRootForm().isMultiPart()) {
            attributes.setMultipart(true);
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }
        if ((submittingComponent = this.getFormSubmittingComponent()) != null) {
            String submittingComponentName = submittingComponent.getInputName();
            attributes.setSubmittingComponentName(submittingComponentName);
        }
    }

    @Override
    protected void onEvent(AjaxRequestTarget target) {
        AjaxFormSubmitter submitter = new AjaxFormSubmitter(this, target);
        Form<?> form = this.getForm();
        form.getRootForm().onFormSubmitted(submitter);
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
    }

    public boolean getDefaultProcessing() {
        return this.defaultProcessing;
    }

    public void setDefaultProcessing(boolean defaultProcessing) {
        this.defaultProcessing = defaultProcessing;
    }

    public static AjaxFormSubmitBehavior onSubmit(String eventName, final SerializableConsumer<AjaxRequestTarget> onSubmit) {
        Args.notNull(onSubmit, (String)"onSubmit");
        return new AjaxFormSubmitBehavior(eventName){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                onSubmit.accept((Object)target);
            }
        };
    }

    public static class AjaxFormSubmitter
    implements IFormSubmitter {
        private final AjaxFormSubmitBehavior submitBehavior;
        private final AjaxRequestTarget target;

        private AjaxFormSubmitter(AjaxFormSubmitBehavior submitBehavior, AjaxRequestTarget target) {
            this.submitBehavior = submitBehavior;
            this.target = target;
        }

        @Override
        public Form<?> getForm() {
            return this.submitBehavior.getForm();
        }

        public IFormSubmittingComponent getFormSubmittingComponent() {
            return this.submitBehavior.getFormSubmittingComponent();
        }

        @Override
        public boolean getDefaultFormProcessing() {
            return this.submitBehavior.getDefaultProcessing();
        }

        @Override
        public void onError() {
            this.submitBehavior.onError(this.target);
        }

        @Override
        public void onSubmit() {
            this.submitBehavior.onSubmit(this.target);
        }

        @Override
        public void onAfterSubmit() {
            this.submitBehavior.onAfterSubmit(this.target);
        }
    }
}

