/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.mock.MockRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.time.Time;

public class MockWebRequest
extends WebRequest {
    private Url url;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private MockRequestParameters postRequestParameters = new MockRequestParameters();
    private Locale locale = Locale.getDefault();
    private String contextPath;
    private String filterPath;
    private String prefixToContextPath = "";

    public MockWebRequest(Url url) {
        this.url = url;
    }

    public MockWebRequest(Url url, String contextPath, String filterPath, String prefixToContextPath) {
        this.url = url;
        this.contextPath = contextPath;
        this.filterPath = filterPath;
        this.prefixToContextPath = prefixToContextPath;
    }

    MockWebRequest(Url url, List<Cookie> cookies, Map<String, List<Object>> headers, MockRequestParameters postRequestParameters, Locale locale) {
        this.url = url;
        this.cookies.addAll(cookies);
        this.headers = headers;
        this.postRequestParameters = postRequestParameters;
        this.locale = locale;
    }

    public MockWebRequest cloneWithUrl(Url url) {
        return new MockWebRequest(url, this.cookies, this.headers, this.postRequestParameters, this.locale);
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public Url getUrl() {
        return this.url;
    }

    public String toString() {
        return "MockWebRequest [url=" + this.url + "]";
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies.clear();
        this.cookies.addAll(cookies);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    public Time getDateHeader(String name) {
        List<Object> dates = this.headers.get(name);
        if (dates == null || dates.isEmpty()) {
            return null;
        }
        Object date = dates.get(0);
        if (!(date instanceof Time)) {
            throw new WicketRuntimeException("Date header with name '" + name + "' is not a valid Time.");
        }
        return (Time)date;
    }

    private void addHeaderObject(String name, Object value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void setDateHeader(String name, Time value) {
        this.removeHeader(name);
        this.addHeaderObject(name, value);
    }

    public void addDateHeader(String name, Time value) {
        this.addHeaderObject(name, value);
    }

    public String getHeader(String name) {
        List<Object> h = this.headers.get(name);
        return h == null || h.isEmpty() ? null : h.get(0).toString();
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.addHeaderObject(name, value);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<String> getHeaders(String name) {
        ArrayList<String> res = new ArrayList<String>();
        List<Object> values = this.headers.get(name);
        if (values != null) {
            for (Object value : values) {
                if (value == null) continue;
                res.add(value.toString());
            }
        }
        return res;
    }

    public void removeHeader(String header) {
        this.headers.remove(header);
    }

    public MockRequestParameters getPostParameters() {
        return this.postRequestParameters;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public Url getClientUrl() {
        Url baseUrl = new Url(this.url.getSegments(), Collections.emptyList());
        baseUrl.setContextRelative(this.url.isContextRelative());
        return baseUrl;
    }

    public Object getContainerRequest() {
        return this;
    }

    public String getContextPath() {
        return UrlUtils.normalizePath((String)this.contextPath);
    }

    public MockWebRequest setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String getFilterPath() {
        return UrlUtils.normalizePath((String)this.filterPath);
    }

    public MockWebRequest setFilterPath(String filterPath) {
        this.filterPath = filterPath;
        return this;
    }

    public String getPrefixToContextPath() {
        return this.prefixToContextPath;
    }

    public MockWebRequest setPrefixToContextPath(String prefixToContextPath) {
        this.prefixToContextPath = prefixToContextPath;
        return this;
    }
}

