/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Classes;

public class InMemoryPageStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private final Map<String, MemoryData> datas = new ConcurrentHashMap<String, MemoryData>();
    private final Supplier<MemoryData> dataCreator;

    public InMemoryPageStore(String applicationName, int maxPages) {
        this(applicationName, () -> new CountLimitedData(maxPages));
    }

    public InMemoryPageStore(String applicationName, Bytes maxBytes) {
        this(applicationName, () -> new SizeLimitedData(maxBytes));
    }

    InMemoryPageStore(String applicationName, Supplier<MemoryData> dataCreator) {
        super(applicationName);
        this.dataCreator = dataCreator;
    }

    @Override
    public boolean supportsVersioning() {
        return false;
    }

    @Override
    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        MemoryData data = this.getMemoryData(sessionIdentifier, false);
        if (data != null) {
            return data.get(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        MemoryData data = this.getMemoryData(sessionIdentifier, false);
        if (data != null) {
            MemoryData memoryData = data;
            synchronized (memoryData) {
                data.remove(page.getPageId());
            }
        }
    }

    @Override
    protected void removeAllPersistedPages(String sessionIdentifier) {
        this.datas.remove(sessionIdentifier);
    }

    @Override
    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        MemoryData data = this.getMemoryData(sessionIdentifier, true);
        data.add(page);
    }

    @Override
    public Set<String> getSessionIdentifiers() {
        return this.datas.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPersistedPage> getPersistedPages(String sessionIdentifier) {
        MemoryData data = this.datas.get(sessionIdentifier);
        if (data == null) {
            return new ArrayList<IPersistedPage>();
        }
        MemoryData memoryData = data;
        synchronized (memoryData) {
            return StreamSupport.stream(data.spliterator(), false).map(page -> {
                String pageType = page instanceof SerializedPage ? ((SerializedPage)page).getPageType() : Classes.name(page.getClass());
                return new AbstractPersistentPageStore.PersistedPage(page.getPageId(), pageType, this.getSize((IManageablePage)page));
            }).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bytes getTotalSize() {
        int size = 0;
        Iterator<MemoryData> iterator = this.datas.values().iterator();
        while (iterator.hasNext()) {
            MemoryData data;
            MemoryData memoryData = data = iterator.next();
            synchronized (memoryData) {
                for (IManageablePage page : data) {
                    size = (int)((long)size + this.getSize(page));
                }
            }
        }
        return Bytes.bytes((long)size);
    }

    protected long getSize(IManageablePage page) {
        if (page instanceof SerializedPage) {
            return ((SerializedPage)page).getData().length;
        }
        return WicketObjects.sizeof((Serializable)((Object)page));
    }

    private MemoryData getMemoryData(String sessionIdentifier, boolean create) {
        if (!create) {
            return this.datas.get(sessionIdentifier);
        }
        MemoryData data = this.dataCreator.get();
        MemoryData existing = this.datas.putIfAbsent(sessionIdentifier, data);
        return existing != null ? existing : data;
    }

    static class SizeLimitedData
    extends MemoryData {
        private Bytes maxBytes;
        private long size;

        public SizeLimitedData(Bytes maxBytes) {
            Args.notNull((Object)maxBytes, (String)"maxBytes");
            this.maxBytes = (Bytes)Args.withinRange((Comparable)Bytes.bytes((long)1L), (Comparable)Bytes.MAX, (Comparable)maxBytes, (String)"maxBytes");
        }

        @Override
        public synchronized void add(IManageablePage page) {
            if (!(page instanceof SerializedPage)) {
                throw new WicketRuntimeException("InMemoryPageStore limited by size works with serialized pages only");
            }
            super.add(page);
            this.size += (long)((SerializedPage)page).getData().length;
            while (this.size > this.maxBytes.bytes()) {
                this.removeOldest();
            }
        }

        @Override
        public synchronized IManageablePage remove(int pageId) {
            SerializedPage page = (SerializedPage)super.remove(pageId);
            if (page != null) {
                this.size -= (long)page.getData().length;
            }
            return page;
        }
    }

    static class CountLimitedData
    extends MemoryData {
        private int maxPages;

        public CountLimitedData(int maxPages) {
            this.maxPages = (Integer)Args.withinRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(maxPages), (String)"maxPages");
        }

        @Override
        public synchronized void add(IManageablePage page) {
            super.add(page);
            while (this.pages.size() > this.maxPages) {
                this.removeOldest();
            }
        }
    }

    static abstract class MemoryData
    implements Iterable<IManageablePage> {
        List<IManageablePage> pages = new LinkedList<IManageablePage>();

        MemoryData() {
        }

        @Override
        public Iterator<IManageablePage> iterator() {
            return this.pages.iterator();
        }

        public synchronized void add(IManageablePage page) {
            this.remove(page.getPageId());
            this.pages.add(page);
        }

        public synchronized IManageablePage remove(int pageId) {
            Iterator<IManageablePage> iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                IManageablePage page = iterator.next();
                if (page.getPageId() != pageId) continue;
                iterator.remove();
                return page;
            }
            return null;
        }

        public synchronized IManageablePage get(int pageId) {
            for (IManageablePage page : this.pages) {
                if (page.getPageId() != pageId) continue;
                return page;
            }
            return null;
        }

        protected void removeOldest() {
            IManageablePage page = this.pages.iterator().next();
            this.remove(page.getPageId());
        }
    }
}

