/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Classes;

public class InSessionPageStore
extends DelegatingPageStore {
    private static final MetaDataKey<SessionData> KEY = new MetaDataKey<SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final ISerializer serializer;
    private final Supplier<SessionData> dataCreator;

    public InSessionPageStore(IPageStore delegate, int maxPages) {
        this(delegate, maxPages, null);
    }

    public InSessionPageStore(IPageStore delegate, int maxPages, ISerializer serializer) {
        this(delegate, serializer, () -> new CountLimitedData(maxPages));
    }

    public InSessionPageStore(IPageStore delegate, Bytes maxBytes) {
        this(delegate, null, () -> new SizeLimitedData(maxBytes));
    }

    private InSessionPageStore(IPageStore delegate, ISerializer serializer, Supplier<SessionData> dataCreator) {
        super(delegate);
        this.serializer = serializer;
        this.dataCreator = dataCreator;
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page;
        SessionData data = this.getSessionData(context, false);
        if (data != null && (page = data.get(id)) != null) {
            return page;
        }
        return this.getDelegate().getPage(context, id);
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        SessionData data = this.getSessionData(context, true);
        data.add(page);
        this.getDelegate().addPage(context, page);
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        SessionData data = this.getSessionData(context, false);
        if (data != null) {
            data.remove(page.getPageId());
        }
        this.getDelegate().removePage(context, page);
    }

    @Override
    public void removeAllPages(IPageContext context) {
        SessionData data = this.getSessionData(context, false);
        if (data != null) {
            data.removeAll();
        }
        this.getDelegate().removeAllPages(context);
    }

    private SessionData getSessionData(IPageContext context, boolean create) {
        SessionData data = context.getSessionData(KEY, () -> {
            if (create) {
                return this.dataCreator.get();
            }
            return null;
        });
        if (data != null && this.serializer != null) {
            data.supportSessionSerialization(this.serializer);
        }
        return data;
    }

    static class SizeLimitedData
    extends SessionData {
        private Bytes maxBytes;
        private long size;

        public SizeLimitedData(Bytes maxBytes) {
            Args.notNull((Object)maxBytes, (String)"maxBytes");
            this.maxBytes = (Bytes)Args.withinRange((Comparable)Bytes.bytes((long)1L), (Comparable)Bytes.MAX, (Comparable)maxBytes, (String)"maxBytes");
        }

        @Override
        public synchronized void add(IManageablePage page) {
            if (!(page instanceof SerializedPage)) {
                throw new WicketRuntimeException("InSessionPageStore limited by size works with serialized pages only");
            }
            super.add(page);
            this.size += (long)((SerializedPage)page).getData().length;
            while (this.size > this.maxBytes.bytes()) {
                this.removeOldest();
            }
        }

        @Override
        public synchronized IManageablePage remove(int pageId) {
            SerializedPage page = (SerializedPage)super.remove(pageId);
            if (page != null) {
                this.size -= (long)page.getData().length;
            }
            return page;
        }

        @Override
        public synchronized void removeAll() {
            super.removeAll();
            this.size = 0L;
        }
    }

    static class CountLimitedData
    extends SessionData {
        private int maxPages;

        public CountLimitedData(int maxPages) {
            this.maxPages = (Integer)Args.withinRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)Integer.valueOf(maxPages), (String)"maxPages");
        }

        @Override
        public synchronized void add(IManageablePage page) {
            super.add(page);
            while (this.pages.size() > this.maxPages) {
                this.removeOldest();
            }
        }
    }

    static abstract class SessionData
    implements Serializable {
        transient ISerializer serializer;
        List<IManageablePage> pages = new LinkedList<IManageablePage>();

        SessionData() {
        }

        public void supportSessionSerialization(ISerializer serializer) {
            this.serializer = (ISerializer)Args.notNull((Object)serializer, (String)"serializer");
        }

        public synchronized void add(IManageablePage page) {
            this.remove(page.getPageId());
            this.pages.add(page);
        }

        protected synchronized void removeOldest() {
            IManageablePage page = this.pages.get(0);
            this.remove(page.getPageId());
        }

        public synchronized IManageablePage remove(int pageId) {
            Iterator<IManageablePage> iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                IManageablePage page = iterator.next();
                if (page.getPageId() != pageId) continue;
                iterator.remove();
                return page;
            }
            return null;
        }

        public synchronized void removeAll() {
            this.pages.clear();
        }

        public synchronized IManageablePage get(int id) {
            for (int p = 0; p < this.pages.size(); ++p) {
                IManageablePage candidate = this.pages.get(p);
                if (candidate.getPageId() != id) continue;
                if (candidate instanceof SerializedPage && this.serializer != null) {
                    candidate = (IManageablePage)this.serializer.deserialize(((SerializedPage)candidate).getData());
                    this.pages.set(p, candidate);
                }
                return candidate;
            }
            return null;
        }

        private void writeObject(ObjectOutputStream output) throws IOException {
            for (int p = 0; p < this.pages.size(); ++p) {
                IManageablePage page = this.pages.get(p);
                if (page instanceof SerializedPage) continue;
                if (this.serializer == null) {
                    this.pages.remove(p);
                    --p;
                    continue;
                }
                this.pages.set(p, new SerializedPage(page.getPageId(), Classes.name(page.getClass()), this.serializer.serialize(page)));
            }
            output.defaultWriteObject();
        }
    }
}

