/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.HttpHeaderCollection;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;

public abstract class AbstractResource
implements IResource {
    private static final long serialVersionUID = 1L;
    public static final Set<String> INTERNAL_HEADERS;
    public static final MetaDataKey<Long> CONTENT_RANGE_STARTBYTE;
    public static final MetaDataKey<Long> CONTENT_RANGE_ENDBYTE;
    public static final String CONTENT_DISPOSITION_HEADER_NAME = "content-disposition";

    protected abstract ResourceResponse newResourceResponse(IResource.Attributes var1);

    protected void configureCache(ResourceResponse data, IResource.Attributes attributes) {
        Response response = attributes.getResponse();
        if (response instanceof WebResponse) {
            Duration duration = data.getCacheDuration();
            WebResponse webResponse = (WebResponse)response;
            if (duration.compareTo((LongValue)Duration.NONE) > 0) {
                webResponse.enableCaching(duration, data.getCacheScope());
            } else {
                webResponse.disableCaching();
            }
        }
    }

    protected IResourceCachingStrategy getCachingStrategy() {
        return Application.get().getResourceSettings().getCachingStrategy();
    }

    @Override
    public void respond(IResource.Attributes attributes) {
        IStaticCacheableResource cacheable;
        this.setRequestMetaData(attributes);
        ResourceResponse data = this.newResourceResponse(attributes);
        if (this instanceof IStaticCacheableResource && (cacheable = (IStaticCacheableResource)((Object)this)).isCachingEnabled()) {
            this.getCachingStrategy().decorateResponse(data, cacheable);
        }
        this.setResponseHeaders(data, attributes);
        if (!data.dataNeedsToBeWritten(attributes) || data.getErrorCode() != null || !this.needsBody(data.getStatusCode())) {
            return;
        }
        if (data.getWriteCallback() == null) {
            throw new IllegalStateException("ResourceResponse#setWriteCallback() must be set.");
        }
        try {
            data.getWriteCallback().writeData(attributes);
        }
        catch (IOException iox) {
            throw new WicketRuntimeException(iox);
        }
    }

    private boolean needsBody(Integer statusCode) {
        return statusCode == null || statusCode < 300 && statusCode != 204 && statusCode != 205;
    }

    private void checkHeaderAccess(String name) {
        if (INTERNAL_HEADERS.contains(name = (String)Args.notEmpty((CharSequence)name.trim().toLowerCase(Locale.ROOT), (String)"name"))) {
            throw new IllegalArgumentException("you are not allowed to directly access header [" + name + "], use one of the other specialized methods of " + Classes.simpleName(this.getClass()) + " to get or modify its value");
        }
    }

    protected void setRequestMetaData(IResource.Attributes attributes) {
        Request request = attributes.getRequest();
        if (request instanceof WebRequest) {
            WebRequest webRequest = (WebRequest)request;
            this.setRequestRangeMetaData(webRequest);
        }
    }

    protected void setRequestRangeMetaData(WebRequest webRequest) {
        String rangeHeader = webRequest.getHeader("range");
        if (!Strings.isEmpty((CharSequence)rangeHeader) && rangeHeader.contains(ContentRangeType.BYTES.getTypeName())) {
            String range = (rangeHeader = rangeHeader.replaceAll(" ", "")).substring(rangeHeader.indexOf(61) + 1, rangeHeader.length());
            int idxOfComma = range.indexOf(44);
            String firstRange = idxOfComma > -1 ? range.substring(0, idxOfComma) : range;
            String[] rangeParts = Strings.split((String)firstRange, (char)'-');
            String startByteString = rangeParts[0];
            String endByteString = rangeParts[1];
            long startbyte = !Strings.isEmpty((CharSequence)startByteString) ? Long.parseLong(startByteString) : 0L;
            long endbyte = !Strings.isEmpty((CharSequence)endByteString) ? Long.parseLong(endByteString) : -1L;
            RequestCycle requestCycle = RequestCycle.get();
            requestCycle.setMetaData((MetaDataKey)CONTENT_RANGE_STARTBYTE, (Object)startbyte);
            requestCycle.setMetaData((MetaDataKey)CONTENT_RANGE_ENDBYTE, (Object)endbyte);
        }
    }

    protected void setResponseHeaders(ResourceResponse resourceResponse, IResource.Attributes attributes) {
        Response response = attributes.getResponse();
        if (response instanceof WebResponse) {
            ContentRangeType acceptRange;
            WebResponse webResponse = (WebResponse)response;
            Time lastModified = resourceResponse.getLastModified();
            if (lastModified != null) {
                webResponse.setLastModifiedTime(lastModified);
            }
            this.configureCache(resourceResponse, attributes);
            if (resourceResponse.getErrorCode() != null) {
                webResponse.sendError(resourceResponse.getErrorCode().intValue(), resourceResponse.getErrorMessage());
                return;
            }
            if (resourceResponse.getStatusCode() != null) {
                webResponse.setStatus(resourceResponse.getStatusCode().intValue());
            }
            if (!resourceResponse.dataNeedsToBeWritten(attributes)) {
                webResponse.setStatus(304);
                return;
            }
            String fileName = resourceResponse.getFileName();
            ContentDisposition disposition = resourceResponse.getContentDisposition();
            if (ContentDisposition.ATTACHMENT == disposition) {
                webResponse.setAttachmentHeader(fileName);
            } else if (ContentDisposition.INLINE == disposition) {
                webResponse.setInlineHeader(fileName);
            }
            String mimeType = resourceResponse.getContentType();
            if (mimeType != null) {
                String encoding = resourceResponse.getTextEncoding();
                if (encoding == null) {
                    webResponse.setContentType(mimeType);
                } else {
                    webResponse.setContentType(mimeType + "; charset=" + encoding);
                }
            }
            if ((acceptRange = resourceResponse.getAcceptRange()) != null) {
                webResponse.setAcceptRange(acceptRange.getTypeName());
            }
            long contentLength = resourceResponse.getContentLength();
            boolean contentRangeApplied = false;
            String contentRange = resourceResponse.getContentRange();
            if (contentRange != null) {
                webResponse.setContentRange(contentRange);
            } else if (contentLength != -1L && ContentRangeType.BYTES.equals((Object)acceptRange)) {
                contentRangeApplied = this.setResponseContentRangeHeaderFields(webResponse, attributes, contentLength);
            }
            if (contentLength != -1L && !contentRangeApplied) {
                webResponse.setContentLength(contentLength);
            }
            HttpHeaderCollection headers = resourceResponse.getHeaders();
            for (String name : headers.getHeaderNames()) {
                this.checkHeaderAccess(name);
                for (String value : headers.getHeaderValues(name)) {
                    webResponse.addHeader(name, value);
                }
            }
        }
    }

    protected boolean setResponseContentRangeHeaderFields(WebResponse webResponse, IResource.Attributes attributes, long contentLength) {
        boolean contentRangeApplied = false;
        if (attributes.getRequest() instanceof WebRequest) {
            Long startbyte = RequestCycle.get().getMetaData(CONTENT_RANGE_STARTBYTE);
            Long endbyte = RequestCycle.get().getMetaData(CONTENT_RANGE_ENDBYTE);
            if (startbyte != null && endbyte != null) {
                if (endbyte == -1L) {
                    endbyte = contentLength - 1L;
                }
                webResponse.setStatus(206);
                webResponse.setContentRange(ContentRangeType.BYTES.getTypeName() + " " + startbyte + "-" + endbyte + "/" + contentLength);
                contentRangeApplied = true;
            }
        }
        return contentRangeApplied;
    }

    static {
        CONTENT_RANGE_STARTBYTE = new MetaDataKey<Long>(){
            private static final long serialVersionUID = 1L;
        };
        CONTENT_RANGE_ENDBYTE = new MetaDataKey<Long>(){
            private static final long serialVersionUID = 1L;
        };
        INTERNAL_HEADERS = new HashSet<String>();
        INTERNAL_HEADERS.add("server");
        INTERNAL_HEADERS.add("date");
        INTERNAL_HEADERS.add("expires");
        INTERNAL_HEADERS.add("last-modified");
        INTERNAL_HEADERS.add("content-type");
        INTERNAL_HEADERS.add("content-length");
        INTERNAL_HEADERS.add(CONTENT_DISPOSITION_HEADER_NAME);
        INTERNAL_HEADERS.add("transfer-encoding");
        INTERNAL_HEADERS.add("connection");
        INTERNAL_HEADERS.add("content-range");
        INTERNAL_HEADERS.add("accept-range");
    }

    public static abstract class WriteCallback {
        public abstract void writeData(IResource.Attributes var1) throws IOException;

        protected final void writeStream(IResource.Attributes attributes, InputStream stream) throws IOException {
            Response response = attributes.getResponse();
            Streams.copy((InputStream)stream, (OutputStream)response.getOutputStream());
        }
    }

    public static class ResourceResponse {
        private Integer errorCode;
        private Integer statusCode;
        private String errorMessage;
        private String fileName = null;
        private ContentDisposition contentDisposition = ContentDisposition.INLINE;
        private String contentType = null;
        private String contentRange = null;
        private ContentRangeType contentRangeType = null;
        private String textEncoding;
        private long contentLength = -1L;
        private Time lastModified = null;
        private WriteCallback writeCallback;
        private Duration cacheDuration;
        private WebResponse.CacheScope cacheScope = WebResponse.CacheScope.PRIVATE;
        private final HttpHeaderCollection headers = new HttpHeaderCollection();

        public ResourceResponse setError(Integer errorCode) {
            this.setError(errorCode, null);
            return this;
        }

        public ResourceResponse setError(Integer errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            return this;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public ResourceResponse setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public ResourceResponse setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public String getFileName() {
            return this.fileName;
        }

        public ResourceResponse setContentDisposition(ContentDisposition contentDisposition) {
            Args.notNull((Object)((Object)contentDisposition), (String)"contentDisposition");
            this.contentDisposition = contentDisposition;
            return this;
        }

        public ContentDisposition getContentDisposition() {
            return this.contentDisposition;
        }

        public ResourceResponse setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public String getContentType() {
            if (this.contentType == null && this.fileName != null) {
                this.contentType = Application.get().getMimeType(this.fileName);
            }
            return this.contentType;
        }

        public String getContentRange() {
            return this.contentRange;
        }

        public void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public ContentRangeType getAcceptRange() {
            return this.contentRangeType;
        }

        public void setAcceptRange(ContentRangeType contentRangeType) {
            this.contentRangeType = contentRangeType;
        }

        public ResourceResponse setTextEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
            return this;
        }

        protected String getTextEncoding() {
            return this.textEncoding;
        }

        public ResourceResponse setContentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public ResourceResponse setLastModified(Time lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Time getLastModified() {
            return this.lastModified;
        }

        public boolean dataNeedsToBeWritten(IResource.Attributes attributes) {
            WebRequest request = (WebRequest)attributes.getRequest();
            Time ifModifiedSince = request.getIfModifiedSinceHeader();
            if (this.cacheDuration != Duration.NONE && ifModifiedSince != null && this.lastModified != null) {
                Time roundedLastModified = Time.millis((long)(this.lastModified.getMilliseconds() / 1000L * 1000L));
                return ifModifiedSince.before((AbstractTimeValue)roundedLastModified);
            }
            return true;
        }

        public ResourceResponse disableCaching() {
            return this.setCacheDuration(Duration.NONE);
        }

        public ResourceResponse setCacheDurationToMaximum() {
            this.cacheDuration = WebResponse.MAX_CACHE_DURATION;
            return this;
        }

        public ResourceResponse setCacheDuration(Duration duration) {
            this.cacheDuration = (Duration)Args.notNull((Object)duration, (String)"duration");
            return this;
        }

        public Duration getCacheDuration() {
            Duration duration = this.cacheDuration;
            if (duration == null && Application.exists()) {
                duration = Application.get().getResourceSettings().getDefaultCacheDuration();
            }
            return duration;
        }

        public WebResponse.CacheScope getCacheScope() {
            return this.cacheScope;
        }

        public ResourceResponse setCacheScope(WebResponse.CacheScope scope) {
            this.cacheScope = (WebResponse.CacheScope)Args.notNull((Object)scope, (String)"scope");
            return this;
        }

        public ResourceResponse setWriteCallback(WriteCallback writeCallback) {
            Args.notNull((Object)writeCallback, (String)"writeCallback");
            this.writeCallback = writeCallback;
            return this;
        }

        public WriteCallback getWriteCallback() {
            return this.writeCallback;
        }

        public HttpHeaderCollection getHeaders() {
            return this.headers;
        }
    }

    public static enum ContentRangeType {
        BYTES("bytes"),
        NONE("none");

        private final String typeName;

        private ContentRangeType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

