/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public abstract class LambdaModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;

    private LambdaModel() {
    }

    @Override
    public void setObject(T t) {
        throw new UnsupportedOperationException("setObject(Object) not supported");
    }

    public static <R> IModel<R> of(SerializableSupplier<R> getter) {
        return () -> getter.get();
    }

    public static <R> IModel<R> of(final SerializableSupplier<R> getter, final SerializableConsumer<R> setter) {
        Args.notNull(getter, (String)"getter");
        Args.notNull(setter, (String)"setter");
        return new LambdaModel<R>(){
            private static final long serialVersionUID = 1L;

            @Override
            public R getObject() {
                return getter.get();
            }

            @Override
            public void setObject(R r) {
                setter.accept(r);
            }
        };
    }

    public static <X, R> IModel<R> of(final IModel<X> target, final SerializableFunction<X, R> getter, final SerializableBiConsumer<X, R> setter) {
        Args.notNull(target, (String)"target");
        Args.notNull(getter, (String)"getter");
        Args.notNull(setter, (String)"setter");
        return new LambdaModel<R>(){
            private static final long serialVersionUID = 1L;

            @Override
            public R getObject() {
                Object x = target.getObject();
                if (x == null) {
                    return null;
                }
                return getter.apply(x);
            }

            @Override
            public void setObject(R r) {
                Object x = target.getObject();
                if (x != null) {
                    setter.accept(x, r);
                }
            }

            @Override
            public void detach() {
                target.detach();
            }
        };
    }
}

