/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.security.Provider;
import java.security.Security;
import java.util.UUID;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.crypt.AbstractKeyInSessionCryptFactory;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.SunJceCrypt;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class KeyInSessionSunJceCryptFactory
extends AbstractKeyInSessionCryptFactory<CryptData> {
    private final String cryptMethod;

    public KeyInSessionSunJceCryptFactory() {
        this("PBEWithMD5AndDES");
    }

    public KeyInSessionSunJceCryptFactory(String cryptMethod) {
        this.cryptMethod = (String)Args.notNull((Object)cryptMethod, (String)"Crypt method");
        Provider[] providers = Security.getProviders("Cipher." + cryptMethod);
        if (providers == null || providers.length == 0) {
            try {
                Class<?> clazz = Class.forName("com.sun.crypto.provider.SunJCE");
                Provider provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Security.addProvider(provider);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to load SunJCE service provider", ex);
            }
        }
    }

    @Deprecated(forRemoval=true)
    protected ICrypt createCrypt() {
        return null;
    }

    @Override
    protected CryptData generateKey(Session session) {
        byte[] salt = SunJceCrypt.randomSalt();
        String key = session.getId() + "." + UUID.randomUUID().toString();
        return new CryptData(key, salt);
    }

    @Override
    protected ICrypt createCrypt(CryptData keyParams) {
        SunJceCrypt crypt = new SunJceCrypt(this.cryptMethod, keyParams.salt, 1000);
        crypt.setKey(keyParams.key);
        return crypt;
    }

    static final class CryptData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        final String key;
        final byte[] salt;

        CryptData(String key, byte[] salt) {
            this.key = key;
            this.salt = salt;
        }
    }
}

