/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard.dynamic;

import java.util.Iterator;
import org.apache.wicket.extensions.wizard.AbstractWizardModel;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.dynamic.IDynamicWizardStep;

public class DynamicWizardModel
extends AbstractWizardModel {
    private static final long serialVersionUID = 1L;
    private IDynamicWizardStep activeStep;
    private final IDynamicWizardStep startStep;

    public DynamicWizardModel(IDynamicWizardStep startStep) {
        this.setActiveStep(startStep);
        this.startStep = startStep;
    }

    public IWizardStep getActiveStep() {
        return this.activeStep;
    }

    public final IDynamicWizardStep getStartStep() {
        return this.startStep;
    }

    public boolean isLastAvailable() {
        return this.activeStep.isLastAvailable();
    }

    public boolean isLastStep(IWizardStep step) {
        return ((IDynamicWizardStep)step).isLastStep();
    }

    public boolean isNextAvailable() {
        return this.activeStep.isNextAvailable();
    }

    public boolean isPreviousAvailable() {
        return this.activeStep.isPreviousAvailable();
    }

    public void last() {
        this.setActiveStep(this.activeStep.last());
    }

    public void next() {
        this.setActiveStep(this.activeStep.next());
    }

    public void previous() {
        this.setActiveStep(this.activeStep.previous());
    }

    public void reset() {
        this.setActiveStep(this.startStep);
    }

    public Iterator stepIterator() {
        return null;
    }

    protected final void setActiveStep(IDynamicWizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("argument step must to be not null");
        }
        step.init(this);
        this.activeStep = step;
        this.fireActiveStepChanged(step);
    }
}

