/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.response.NullResponse;

final class MiddleColumnsView
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final List<IColumn> columns = new ArrayList<IColumn>();
    private final List<Component> components = new ArrayList<Component>();
    private final TreeNode node;
    private final List<IRenderable> renderables = new ArrayList<IRenderable>();
    private boolean treeHasLeftColumn;

    public MiddleColumnsView(String id, TreeNode node, boolean treeHasLeftColumn) {
        super(id);
        this.node = node;
        this.treeHasLeftColumn = treeHasLeftColumn;
    }

    public void addColumn(IColumn column, Component component, IRenderable renderable) {
        if (column.isVisible()) {
            this.columns.add(column);
            this.components.add(component);
            this.renderables.add(renderable);
        }
    }

    protected double[] computeColumnWidths() {
        int i;
        double[] result = new double[this.columns.size()];
        Arrays.fill(result, 0.0);
        double sum = 0.0;
        double whole = 99.8;
        for (IColumn column : this.columns) {
            if (column.getLocation().getUnit() != ColumnLocation.Unit.PROPORTIONAL) {
                throw new IllegalStateException("Middle columns must have PROPORTIONAL unit set.");
            }
            sum += (double)column.getLocation().getSize();
        }
        int index = 0;
        int spanColumn = 0;
        int spanLeft = 0;
        for (IColumn column : this.columns) {
            int ix = index;
            if (spanLeft > 0) {
                ix = spanColumn;
                --spanLeft;
            }
            int n = ix;
            result[n] = result[n] + (double)Math.round((double)column.getLocation().getSize() / sum * whole);
            if (spanLeft == 0 && column.getSpan(this.node) > 1) {
                int maxSpan = this.columns.size() - this.columns.indexOf(column);
                int span = column.getSpan(this.node) - 1;
                spanColumn = index;
                spanLeft = span < maxSpan ? span : maxSpan;
            }
            ++index;
        }
        double together = 0.0;
        for (i = 0; i < result.length; ++i) {
            together += result[i];
        }
        if (together > 99.8) {
            for (i = result.length - 1; i >= 0; --i) {
                if (result[i] == 0.0) continue;
                int n = i;
                result[n] = result[n] - (together - 99.8);
                break;
            }
        }
        return result;
    }

    protected void onRender(MarkupStream markupStream) {
        int markupStart = markupStream.getCurrentIndex();
        Response response = RequestCycle.get().getResponse();
        double[] widths = this.computeColumnWidths();
        boolean rendered = false;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(0);
        nf.setMaximumFractionDigits(2);
        for (int i = 0; i < this.columns.size(); ++i) {
            Component component = this.components.get(i);
            IRenderable renderable = this.renderables.get(i);
            IColumn column = this.columns.get(i);
            response.write((CharSequence)("<span class=\"b_\" style=\"width:" + nf.format(widths[i]) + "%\">"));
            if (!this.treeHasLeftColumn && i == 0) {
                response.write((CharSequence)"<span class=\"d_\">");
            } else {
                response.write((CharSequence)"<span class=\"c_\">");
            }
            if (component != null) {
                markupStream.setCurrentIndex(markupStart);
                component.render(markupStream);
                rendered = true;
            } else if (renderable != null) {
                renderable.render(this.node, response);
            } else {
                throw new IllegalStateException("Either renderable or cell component must be created for this noode");
            }
            response.write((CharSequence)"</span></span>\n");
            int span = column.getSpan(this.node);
            if (span <= 1) continue;
            for (int j = 1; j < span && i < this.components.size(); ++j) {
                if (this.components.get(++i) == null) continue;
                Response old = RequestCycle.get().setResponse((Response)NullResponse.getInstance());
                markupStream.setCurrentIndex(markupStart);
                this.components.get(i).render(markupStream);
                RequestCycle.get().setResponse(old);
                rendered = true;
            }
        }
        if (!rendered) {
            markupStream.skipComponent();
        }
    }
}

