/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.sort;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByLink
extends Link<Void> {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final ISortStateLocator stateLocator;

    public OrderByLink(String id, String property, ISortStateLocator stateLocator) {
        this(id, property, stateLocator, DefaultCssProvider.getInstance());
    }

    public OrderByLink(String id, String property, ISortStateLocator stateLocator, ICssProvider cssProvider) {
        super(id);
        if (cssProvider == null) {
            throw new IllegalArgumentException("argument [cssProvider] cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("argument [sortProperty] cannot be null");
        }
        this.property = property;
        this.stateLocator = stateLocator;
        this.add(new Behavior[]{new CssModifier(this, cssProvider)});
    }

    public final void onClick() {
        this.sort();
        this.onSortChanged();
    }

    protected void onSortChanged() {
    }

    public final OrderByLink sort() {
        if (this.isVersioned()) {
            this.addStateChange();
        }
        ISortState state = this.stateLocator.getSortState();
        SortOrder order = state.getPropertySortOrder(this.property);
        state.setPropertySortOrder(this.property, this.nextSortOrder(order));
        return this;
    }

    protected SortOrder nextSortOrder(SortOrder order) {
        if (order == SortOrder.NONE) {
            return SortOrder.ASCENDING;
        }
        return order == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }

    public static class DefaultCssProvider
    extends CssProvider {
        private static final long serialVersionUID = 1L;
        private static DefaultCssProvider instance = new DefaultCssProvider();

        private DefaultCssProvider() {
            super("wicket_orderUp", "wicket_orderDown", "wicket_orderNone");
        }

        public static DefaultCssProvider getInstance() {
            return instance;
        }
    }

    public static class VoidCssProvider
    extends CssProvider {
        private static final long serialVersionUID = 1L;
        private static ICssProvider instance = new VoidCssProvider();

        public static ICssProvider getInstance() {
            return instance;
        }

        private VoidCssProvider() {
            super("", "", "");
        }
    }

    public static class CssProvider
    implements ICssProvider {
        private static final long serialVersionUID = 1L;
        private final String ascending;
        private final String descending;
        private final String none;

        public CssProvider(String ascending, String descending, String none) {
            this.ascending = ascending;
            this.descending = descending;
            this.none = none;
        }

        public String getClassAttributeValue(ISortState state, String property) {
            SortOrder dir = state.getPropertySortOrder(property);
            if (dir == SortOrder.ASCENDING) {
                return this.ascending;
            }
            if (dir == SortOrder.DESCENDING) {
                return this.descending;
            }
            return this.none;
        }
    }

    public static interface ICssProvider
    extends IClusterable {
        public String getClassAttributeValue(ISortState var1, String var2);
    }

    public static class CssModifier
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final OrderByLink link;
        private final ICssProvider provider;

        public CssModifier(OrderByLink link, ICssProvider provider) {
            this.link = link;
            this.provider = provider;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            ISortState sortState = this.link.stateLocator.getSortState();
            String cssClass = this.provider.getClassAttributeValue(sortState, this.link.property);
            if (!Strings.isEmpty((CharSequence)cssClass)) {
                tag.append("class", (CharSequence)cssClass, " ");
            }
        }
    }
}

