/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable<T>
extends Panel
implements IPageableItems {
    private static final long serialVersionUID = 1L;
    private final DataGridView<T> datagrid;
    private final WebMarkupContainer body;
    private final List<IColumn<T>> columns;
    private final ToolbarsContainer topToolbars;
    private final ToolbarsContainer bottomToolbars;
    private final Caption caption;

    public DataTable(String id, List<IColumn<T>> columns, IDataProvider<T> dataProvider, int rowsPerPage) {
        super(id);
        if (columns == null || columns.size() < 1) {
            throw new IllegalArgumentException("Argument `columns` cannot be null or empty");
        }
        this.columns = columns;
        this.caption = new Caption("caption", this.getCaptionModel());
        this.add(new Component[]{this.caption});
        this.body = this.newBodyContainer("body");
        this.datagrid = new DataGridView<T>("rows", columns, dataProvider){
            private static final long serialVersionUID = 1L;

            @Override
            protected Item newCellItem(String id, int index, IModel model) {
                Item item = DataTable.this.newCellItem(id, index, model);
                final IColumn column = (IColumn)DataTable.this.columns.get(index);
                if (column instanceof IStyledColumn) {
                    item.add(new Behavior[]{new CssAttributeBehavior(){
                        private static final long serialVersionUID = 1L;

                        protected String getCssClass() {
                            return ((IStyledColumn)column).getCssClass();
                        }
                    }});
                }
                return item;
            }

            @Override
            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                return DataTable.this.newRowItem(id, index, model);
            }
        };
        this.datagrid.setItemsPerPage(rowsPerPage);
        this.body.add(new Component[]{this.datagrid});
        this.add(new Component[]{this.body});
        this.topToolbars = new ToolbarsContainer("topToolbars");
        this.bottomToolbars = new ToolbarsContainer("bottomToolbars");
        this.add(new Component[]{this.topToolbars});
        this.add(new Component[]{this.bottomToolbars});
    }

    protected IModel<String> getCaptionModel() {
        return null;
    }

    protected WebMarkupContainer newBodyContainer(String id) {
        return new WebMarkupContainer(id);
    }

    public final void setTableBodyCss(String cssStyle) {
        this.body.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)cssStyle))});
    }

    public void addBottomToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.bottomToolbars);
    }

    public void addTopToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.topToolbars);
    }

    public final IDataProvider<T> getDataProvider() {
        return this.datagrid.getDataProvider();
    }

    public final List<IColumn<T>> getColumns() {
        return this.columns;
    }

    public final int getCurrentPage() {
        return this.datagrid.getCurrentPage();
    }

    public final int getPageCount() {
        return this.datagrid.getPageCount();
    }

    public final int getRowCount() {
        return this.datagrid.getRowCount();
    }

    public final int getItemsPerPage() {
        return this.datagrid.getItemsPerPage();
    }

    public final void setCurrentPage(int page) {
        this.datagrid.setCurrentPage(page);
        this.onPageChanged();
    }

    public final DataTable<T> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.datagrid.setItemReuseStrategy(strategy);
        return this;
    }

    public void setItemsPerPage(int items) {
        this.datagrid.setItemsPerPage(items);
    }

    public int getItemCount() {
        return this.datagrid.getItemCount();
    }

    private void addToolbar(AbstractToolbar toolbar, ToolbarsContainer container) {
        if (toolbar == null) {
            throw new IllegalArgumentException("argument [toolbar] cannot be null");
        }
        container.getRepeatingView().add(new Component[]{toolbar});
    }

    protected Item<IColumn<T>> newCellItem(String id, int index, IModel<IColumn<T>> model) {
        return new Item(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new Item(id, index, model);
    }

    protected void onDetach() {
        super.onDetach();
        for (IColumn<T> column : this.columns) {
            column.detach();
        }
    }

    protected void onPageChanged() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Caption
    extends Label {
        public Caption(String id, IModel<String> model) {
            super(id, model);
        }

        protected void onConfigure() {
            this.setRenderBodyOnly(Strings.isEmpty((CharSequence)this.getDefaultModelObjectAsString()));
            super.onConfigure();
        }

        protected IModel<?> initModel() {
            return null;
        }
    }

    private static class ToolbarsContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final RepeatingView toolbars = new RepeatingView("toolbars");

        private ToolbarsContainer(String id) {
            super(id);
            this.add(new Component[]{this.toolbars});
        }

        public RepeatingView getRepeatingView() {
            return this.toolbars;
        }

        public void onConfigure() {
            super.onConfigure();
            this.toolbars.configure();
            Boolean visible = (Boolean)this.toolbars.visitChildren((IVisitor)new IVisitor<Component, Boolean>(){

                public void component(Component object, IVisit<Boolean> visit) {
                    object.configure();
                    if (object.isVisible()) {
                        visit.stop((Object)Boolean.TRUE);
                    } else {
                        visit.dontGoDeeper();
                    }
                }
            });
            if (visible == null) {
                visible = false;
            }
            this.setVisible(visible);
        }
    }

    static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        CssAttributeBehavior() {
        }

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((CharSequence)className)) {
                String oldClassName = tag.getAttribute("class");
                if (Strings.isEmpty((CharSequence)oldClassName)) {
                    tag.put("class", (CharSequence)className);
                } else {
                    tag.put("class", (CharSequence)(oldClassName + " " + className));
                }
            }
        }
    }
}

