/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class NavigatorLabel
extends Label {
    private static final long serialVersionUID = 1L;

    public NavigatorLabel(String id, IPageableItems pageable) {
        super(id);
        this.setDefaultModel((IModel)new StringResourceModel("NavigatorLabel", (Component)this, (IModel)new Model((Serializable)((Object)new LabelModelObject(pageable))), "Showing ${from} to ${to} of ${of}", new Object[0]));
    }

    private static class LabelModelObject
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final IPageableItems pageable;

        public LabelModelObject(IPageableItems table) {
            this.pageable = table;
        }

        public int getOf() {
            return this.pageable.getItemCount();
        }

        public int getFrom() {
            if (this.getOf() == 0) {
                return 0;
            }
            return this.pageable.getCurrentPage() * this.pageable.getItemsPerPage() + 1;
        }

        public int getTo() {
            if (this.getOf() == 0) {
                return 0;
            }
            return Math.min(this.getOf(), this.getFrom() + this.pageable.getItemsPerPage() - 1);
        }
    }
}

