/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public abstract class AjaxLazyLoadPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String LAZY_LOAD_COMPONENT_ID = "content";
    private byte state = 0;

    public AjaxLazyLoadPanel(String id) {
        this(id, null);
    }

    public AjaxLazyLoadPanel(String id, IModel<?> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                if (AjaxLazyLoadPanel.this.state < 2) {
                    Component component = AjaxLazyLoadPanel.this.getLazyLoadComponent(AjaxLazyLoadPanel.LAZY_LOAD_COMPONENT_ID);
                    AjaxLazyLoadPanel.this.replace(component);
                    AjaxLazyLoadPanel.this.setState((byte)2);
                }
                target.add(new Component[]{AjaxLazyLoadPanel.this});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxLazyLoadPanel.this.updateAjaxAttributes(attributes);
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                if (AjaxLazyLoadPanel.this.state < 2) {
                    CharSequence js = this.getCallbackScript(component);
                    AjaxLazyLoadPanel.this.handleCallbackScript(response, js, component);
                }
            }
        }});
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void handleCallbackScript(IHeaderResponse response, CharSequence callbackScript, Component component) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)callbackScript));
    }

    protected void onBeforeRender() {
        if (this.state == 0) {
            this.add(new Component[]{this.getLoadingComponent(LAZY_LOAD_COMPONENT_ID)});
            this.setState((byte)1);
        }
        super.onBeforeRender();
    }

    private void setState(byte state) {
        this.state = state;
        this.getPage().dirty();
    }

    public abstract Component getLazyLoadComponent(String var1);

    public Component getLoadingComponent(String markupId) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        return new Label(markupId, "<img alt=\"Loading...\" src=\"" + RequestCycle.get().urlFor((IRequestHandler)handler) + "\"/>").setEscapeModelStrings(false);
    }
}

