/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.jmx.ResourceSettingsMBean;
import org.apache.wicket.jmx.Stringz;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Duration;

public class ResourceSettings
implements ResourceSettingsMBean {
    private final Application application;

    public ResourceSettings(Application application) {
        this.application = application;
    }

    public String getLocalizer() {
        return Stringz.className(this.application.getResourceSettings().getLocalizer());
    }

    public String getPackageResourceGuard() {
        return Stringz.className(this.application.getResourceSettings().getPackageResourceGuard());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPropertiesFactory() {
        ThreadContext.setApplication((Application)this.application);
        try {
            String string = Stringz.className(this.application.getResourceSettings().getPropertiesFactory());
            return string;
        }
        finally {
            ThreadContext.detach();
        }
    }

    public String getResourceFinder() {
        return Stringz.className(this.application.getResourceSettings().getResourceFinder());
    }

    public String getResourcePollFrequency() {
        Duration duration = this.application.getResourceSettings().getResourcePollFrequency();
        return duration != null ? duration.toString() : null;
    }

    public String getResourceStreamLocator() {
        return Stringz.className(this.application.getResourceSettings().getResourceStreamLocator());
    }

    public String[] getStringResourceLoaders() {
        List loaders = this.application.getResourceSettings().getStringResourceLoaders();
        if (loaders != null) {
            ArrayList list = Generics.newArrayList();
            for (IStringResourceLoader loader : loaders) {
                list.add(loader.toString());
            }
            return list.toArray(new String[loaders.size()]);
        }
        return null;
    }

    public boolean getThrowExceptionOnMissingResource() {
        return this.application.getResourceSettings().getThrowExceptionOnMissingResource();
    }

    public boolean getUseDefaultOnMissingResource() {
        return this.application.getResourceSettings().getUseDefaultOnMissingResource();
    }

    public void setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.application.getResourceSettings().setThrowExceptionOnMissingResource(throwExceptionOnMissingResource);
    }

    public void setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.application.getResourceSettings().setUseDefaultOnMissingResource(useDefaultOnMissingResource);
    }
}

