/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws;

import java.util.concurrent.Callable;
import org.apache.wicket.protocol.ws.IWebSocketSettings;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.SimpleWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.concurrent.Executor;
import org.apache.wicket.util.lang.Args;

public class WebSocketSettings
implements IWebSocketSettings {
    private Executor webSocketPushMessageExecutor = new SameThreadExecutor();
    private Executor sendPayloadExecutor = new SameThreadExecutor();
    private IWebSocketConnectionRegistry connectionRegistry = new SimpleWebSocketConnectionRegistry();

    @Override
    public IWebSocketSettings setWebSocketPushMessageExecutor(Executor executor) {
        Args.notNull((Object)executor, (String)"executor");
        this.webSocketPushMessageExecutor = executor;
        return this;
    }

    @Override
    public IWebSocketConnectionRegistry getConnectionRegistry() {
        return this.connectionRegistry;
    }

    @Override
    public IWebSocketSettings setConnectionRegistry(IWebSocketConnectionRegistry connectionRegistry) {
        Args.notNull((Object)connectionRegistry, (String)"connectionRegistry");
        this.connectionRegistry = connectionRegistry;
        return this;
    }

    @Override
    public Executor getWebSocketPushMessageExecutor() {
        return this.webSocketPushMessageExecutor;
    }

    public WebSocketSettings setSendPayloadExecutor(Executor sendPayloadExecutor) {
        Args.notNull((Object)sendPayloadExecutor, (String)"sendPayloadExecutor");
        this.sendPayloadExecutor = sendPayloadExecutor;
        return this;
    }

    public Executor getSendPayloadExecutor() {
        return this.sendPayloadExecutor;
    }

    public static class SameThreadExecutor
    implements Executor {
        @Override
        public void run(Runnable command) {
            command.run();
        }

        @Override
        public <T> T call(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }
}

