/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.NullProvider;
import org.apache.wicket.util.lang.Args;

public class ParentPathReferenceRewriter
implements IRequestMapperDelegate {
    private final IProvider<String> escapeSequence;
    private final IRequestMapper chain;

    public ParentPathReferenceRewriter(IRequestMapper chain, IProvider<String> escapeSequence) {
        Args.notNull((Object)chain, (String)"chain");
        Args.notNull(escapeSequence, (String)"relativePathPartEscapeSequence");
        this.escapeSequence = escapeSequence;
        this.chain = chain;
    }

    public ParentPathReferenceRewriter(IRequestMapper chain) {
        this(chain, (IProvider<String>)new NullProvider());
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        Url url = request.getUrl();
        if (this.escapeSequence.get() != null) {
            for (int i = 0; i < url.getSegments().size(); ++i) {
                if (!url.getSegments().get(i).equals(this.escapeSequence.get())) continue;
                url.getSegments().set(i, "..");
            }
        }
        return this.chain.mapRequest(request.cloneWithUrl(url));
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.chain.mapHandler(requestHandler);
        if (url != null && this.escapeSequence.get() != null) {
            for (int i = 0; i < url.getSegments().size(); ++i) {
                if (!"..".equals(url.getSegments().get(i))) continue;
                url.getSegments().set(i, (String)this.escapeSequence.get());
            }
        }
        return url;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return this.chain.getCompatibilityScore(request);
    }

    @Override
    public IRequestMapper getDelegateMapper() {
        return this.chain;
    }
}

