/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.converter.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTimeConverter
extends AbstractConverter<Time> {
    private static final long serialVersionUID = 1L;

    @Override
    public Time convertToObject(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = (DateFormat)DateFormat.getTimeInstance(3, locale).clone();
        try {
            Date date = format.parse(value);
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new ConversionException("Cannot parse '" + value + "' using format " + format).setSourceValue(value).setTargetType(this.getTargetType()).setConverter(this).setLocale(locale);
        }
    }

    @Override
    public String convertToString(Time time, Locale locale) {
        if (time == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = (DateFormat)DateFormat.getTimeInstance(3, locale).clone();
        return format.format(time);
    }

    @Override
    protected Class<Time> getTargetType() {
        return Time.class;
    }
}

