/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.string;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.StringEscapeUtils;
import org.apache.wicket.util.string.StringValueConversionException;

public final class Strings {
    public static final String LINE_SEPARATOR;
    private static final char[] HEX_DIGIT;
    private static final Pattern HTML_NUMBER_REGEX;
    private static final String[] NO_STRINGS;

    private Strings() {
    }

    public static String afterFirst(String s, char c) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(c);
        if (index == -1) {
            return "";
        }
        return s.substring(index + 1);
    }

    public static String afterFirstPathComponent(String path, char separator) {
        return Strings.afterFirst(path, separator);
    }

    public static String afterLast(String s, char c) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(c);
        if (index == -1) {
            return "";
        }
        return s.substring(index + 1);
    }

    public static String beforeFirst(String s, char c) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(c);
        if (index == -1) {
            return "";
        }
        return s.substring(0, index);
    }

    public static String beforeLast(String s, char c) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(c);
        if (index == -1) {
            return "";
        }
        return s.substring(0, index);
    }

    public static String beforeLastPathComponent(String path, char separator) {
        return Strings.beforeLast(path, separator);
    }

    public static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        return new String(chars);
    }

    public static CharSequence escapeMarkup(CharSequence s) {
        return Strings.escapeMarkup(s, false);
    }

    public static CharSequence escapeMarkup(CharSequence s, boolean escapeSpaces) {
        return Strings.escapeMarkup(s, escapeSpaces, false);
    }

    public static CharSequence escapeMarkup(CharSequence s, boolean escapeSpaces, boolean convertToHtmlUnicodeEscapes) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        AppendingStringBuffer buffer = new AppendingStringBuffer((int)((double)len * 1.1));
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    if (escapeSpaces) {
                        buffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                        continue block9;
                    }
                    buffer.append(c);
                    continue block9;
                }
                case ' ': {
                    if (escapeSpaces) {
                        buffer.append("&nbsp;");
                        continue block9;
                    }
                    buffer.append(c);
                    continue block9;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    buffer.append("&#039;");
                    continue block9;
                }
                default: {
                    int ci = 0xFFFF & c;
                    if (ci < 32 && ci != 9 && ci != 10 && ci != 13 || convertToHtmlUnicodeEscapes && ci > 159) {
                        buffer.append("&#");
                        buffer.append(Integer.toString(ci));
                        buffer.append(';');
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer;
    }

    public static CharSequence unescapeMarkup(String markup) {
        String unescapedMarkup = StringEscapeUtils.unescapeHtml(markup);
        return unescapedMarkup;
    }

    public static String firstPathComponent(String path, char separator) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(separator);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String fromEscapedUnicode(String escapedUnicodeString) {
        int off = 0;
        char[] in = escapedUnicodeString.toCharArray();
        int len = in.length;
        char[] out = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static boolean isEmpty(CharSequence string) {
        return string == null || string.length() == 0 || string.toString().trim().length() == 0;
    }

    public static boolean isEqual(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (Strings.isEmpty(string1) && Strings.isEmpty(string2)) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equals(string2);
    }

    public static boolean isTrue(String s) throws StringValueConversionException {
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            if (s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("off") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n") || s.equalsIgnoreCase("0")) {
                return false;
            }
            if (Strings.isEmpty(s)) {
                return false;
            }
            throw new StringValueConversionException("Boolean value \"" + s + "\" not recognized");
        }
        return false;
    }

    public static String join(String separator, List<String> fragments) {
        if (fragments == null) {
            return "";
        }
        return Strings.join(separator, fragments.toArray(new String[fragments.size()]));
    }

    public static String join(String separator, String ... fragments) {
        if (fragments == null || fragments.length < 1) {
            return "";
        }
        if (fragments.length < 2) {
            return fragments[0];
        }
        StringBuilder buff = new StringBuilder(128);
        if (fragments[0] != null) {
            buff.append(fragments[0]);
        }
        for (int i = 1; i < fragments.length; ++i) {
            String fragment = fragments[i];
            if (fragments[i - 1] == null && fragment == null) continue;
            boolean lhsClosed = fragments[i - 1].endsWith(separator);
            boolean rhsClosed = fragment.startsWith(separator);
            if (lhsClosed && rhsClosed) {
                buff.append(fragment.substring(1));
                continue;
            }
            if (!lhsClosed && !rhsClosed) {
                if (!Strings.isEmpty(fragment)) {
                    buff.append(separator);
                }
                buff.append(fragment);
                continue;
            }
            buff.append(fragment);
        }
        return buff.toString();
    }

    public static String lastPathComponent(String path, char separator) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(separator);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static CharSequence replaceAll(CharSequence s, CharSequence searchFor, CharSequence replaceWith) {
        int searchForLength;
        String searchString;
        int matchIndex;
        if (s == null) {
            return null;
        }
        if (searchFor == null || "".equals(searchFor)) {
            return s;
        }
        if (replaceWith == null) {
            replaceWith = "";
        }
        if ((matchIndex = Strings.search(s, searchString = searchFor.toString(), 0)) == -1) {
            return s;
        }
        int size = s.length();
        int replaceWithLength = replaceWith.length();
        if (replaceWithLength > (searchForLength = searchFor.length())) {
            size += replaceWithLength - searchForLength;
        }
        AppendingStringBuffer buffer = new AppendingStringBuffer(size + 16);
        int pos = 0;
        do {
            Strings.append(buffer, s, pos, matchIndex);
            buffer.append(replaceWith);
        } while ((matchIndex = Strings.search(s, searchString, pos = matchIndex + searchForLength)) != -1);
        buffer.append(s.subSequence(pos, s.length()));
        return buffer;
    }

    public static String replaceHtmlEscapeNumber(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = HTML_NUMBER_REGEX.matcher(str);
        while (matcher.find()) {
            int pos = matcher.start();
            int end = matcher.end();
            int number = Integer.parseInt(str.substring(pos + 2, end - 1));
            char ch = (char)number;
            str = str.substring(0, pos) + ch + str.substring(end);
            matcher = HTML_NUMBER_REGEX.matcher(str);
        }
        return str;
    }

    public static String[] split(String s, char c) {
        if (s == null || s.length() == 0) {
            return NO_STRINGS;
        }
        ArrayList<String> strings = new ArrayList<String>();
        int pos = 0;
        while (true) {
            int next;
            if ((next = s.indexOf(c, pos)) == -1) break;
            strings.add(s.substring(pos, next));
            pos = next + 1;
        }
        strings.add(s.substring(pos));
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static String stripEnding(String s, String ending) {
        int endpos;
        int sLength;
        if (s == null) {
            return null;
        }
        if (ending == null || "".equals(ending)) {
            return s;
        }
        int endingLength = ending.length();
        if (endingLength > (sLength = s.length())) {
            return s;
        }
        int index = s.lastIndexOf(ending);
        if (index == (endpos = sLength - endingLength)) {
            return s.substring(0, endpos);
        }
        return s;
    }

    public static String stripJSessionId(String url) {
        if (url == null) {
            return null;
        }
        int ixSemiColon = url.indexOf(";");
        if (ixSemiColon == -1) {
            return url;
        }
        int ixQuestionMark = url.indexOf("?");
        if (ixQuestionMark == -1) {
            return url.substring(0, ixSemiColon);
        }
        if (ixQuestionMark <= ixSemiColon) {
            return url;
        }
        return url.substring(0, ixSemiColon) + url.substring(ixQuestionMark);
    }

    public static Boolean toBoolean(String s) throws StringValueConversionException {
        return Strings.isTrue(s);
    }

    public static char toChar(String s) throws StringValueConversionException {
        if (s != null) {
            if (s.length() == 1) {
                return s.charAt(0);
            }
            throw new StringValueConversionException("Expected single character, not \"" + s + "\"");
        }
        throw new StringValueConversionException("Character value was null");
    }

    public static String toEscapedUnicode(String unicodeString) {
        if (unicodeString == null || unicodeString.length() == 0) {
            return unicodeString;
        }
        int len = unicodeString.length();
        int bufLen = len * 2;
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = unicodeString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Strings.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Strings.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Strings.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Strings.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static CharSequence toMultilineMarkup(CharSequence s) {
        if (s == null) {
            return null;
        }
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        int newlineCount = 0;
        buffer.append("<p>");
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    ++newlineCount;
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
                default: {
                    if (newlineCount == 1) {
                        buffer.append("<br/>");
                    } else if (newlineCount > 1) {
                        buffer.append("</p><p>");
                    }
                    buffer.append(c);
                    newlineCount = 0;
                }
            }
        }
        if (newlineCount == 1) {
            buffer.append("<br/>");
        } else if (newlineCount > 1) {
            buffer.append("</p><p>");
        }
        buffer.append("</p>");
        return buffer;
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Throwable) {
            return Strings.toString((Throwable)object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[] && ((String[])object).length == 1) {
            return ((String[])object)[0];
        }
        return object.toString();
    }

    public static String toString(Throwable throwable) {
        if (throwable != null) {
            Throwable cause;
            ArrayList<Throwable> al = new ArrayList<Throwable>();
            al.add(cause);
            for (cause = throwable; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                al.add(cause);
            }
            AppendingStringBuffer sb = new AppendingStringBuffer(256);
            int length = al.size() - 1;
            cause = (Throwable)al.get(length);
            if (throwable instanceof RuntimeException) {
                sb.append("Message: ");
                sb.append(throwable.getMessage());
                sb.append("\n\n");
            }
            sb.append("Root cause:\n\n");
            Strings.outputThrowable(cause, sb, false);
            if (length > 0) {
                sb.append("\n\nComplete stack:\n\n");
                for (int i = 0; i < length; ++i) {
                    Strings.outputThrowable((Throwable)al.get(i), sb, true);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        return "<Null Throwable>";
    }

    private static void append(AppendingStringBuffer buffer, CharSequence s, int from, int to) {
        if (s instanceof AppendingStringBuffer) {
            AppendingStringBuffer asb = (AppendingStringBuffer)s;
            buffer.append(asb.getValue(), from, to - from);
        } else {
            buffer.append(s.subSequence(from, to));
        }
    }

    private static void outputThrowable(Throwable cause, AppendingStringBuffer sb, boolean stopAtWicketServlet) {
        sb.append(cause);
        sb.append("\n");
        StackTraceElement[] trace = cause.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            String traceString = trace[i].toString();
            if (traceString.startsWith("sun.reflect.") && i > 1) continue;
            sb.append("     at ");
            sb.append(traceString);
            sb.append("\n");
            if (!stopAtWicketServlet || !traceString.startsWith("org.apache.wicket.protocol.http.WicketServlet") && !traceString.startsWith("org.apache.wicket.protocol.http.WicketFilter")) continue;
            return;
        }
    }

    private static int search(CharSequence s, String searchString, int pos) {
        if (s instanceof String) {
            return ((String)s).indexOf(searchString, pos);
        }
        if (s instanceof StringBuffer) {
            return ((StringBuffer)s).indexOf(searchString, pos);
        }
        if (s instanceof StringBuilder) {
            return ((StringBuilder)s).indexOf(searchString, pos);
        }
        if (s instanceof AppendingStringBuffer) {
            return ((AppendingStringBuffer)s).indexOf(searchString, pos);
        }
        return s.toString().indexOf(searchString, pos);
    }

    private static char toHex(int nibble) {
        return HEX_DIGIT[nibble & 0xF];
    }

    public static int lengthInBytes(String string, Charset charset) {
        if (string == null) {
            throw new NullPointerException("Argument `string` cannot be null");
        }
        if (charset != null) {
            try {
                return string.getBytes(charset.name()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("StringResourceStream created with unsupported charset: " + charset.name());
            }
        }
        return string.getBytes().length;
    }

    public static boolean startsWith(String str, String prefix, boolean caseSensitive) {
        if (caseSensitive) {
            return str.startsWith(prefix);
        }
        return str.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static int indexOf(CharSequence sequence, char ch) {
        if (sequence != null) {
            for (int i = 0; i < sequence.length(); ++i) {
                if (sequence.charAt(i) != ch) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static String toHexString(byte[] bytes) {
        Args.notNull(bytes, "bytes");
        StringBuilder hex = new StringBuilder(bytes.length << 1);
        for (byte b : bytes) {
            hex.append(Strings.toHex(b >> 4));
            hex.append(Strings.toHex(b));
        }
        return hex.toString();
    }

    public static <T extends Enum<T>> T toEnum(CharSequence value, Class<T> enumClass) {
        Args.notNull(enumClass, "enumClass");
        Args.notNull(value, "value");
        try {
            return Enum.valueOf(enumClass, value.toString());
        }
        catch (Exception e) {
            throw new StringValueConversionException(String.format("Cannot convert '{}' to enum constant of type '{}'.", value, enumClass), e);
        }
    }

    static {
        HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HTML_NUMBER_REGEX = Pattern.compile("&#\\d+;");
        NO_STRINGS = new String[0];
        LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
    }
}

