/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractIntegerConverter;
import org.apache.wicket.util.string.Strings;

public class BigIntegerConverter
extends AbstractIntegerConverter<BigInteger> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Class<BigInteger> getTargetType() {
        return BigInteger.class;
    }

    @Override
    public BigInteger convertToObject(String value, Locale locale) {
        if (Strings.isEmpty(value)) {
            return null;
        }
        Object number = this.parse(value, -1.7976931348623157E308, Double.MAX_VALUE, locale);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf(((Number)number).longValue());
        }
        if (number instanceof Integer) {
            return BigInteger.valueOf(((Number)number).intValue());
        }
        return new BigInteger(value);
    }
}

