/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public final class CsvReader {
    private Reader reader;
    private boolean endOfLine = false;
    private boolean endOfFile = false;

    public CsvReader(Reader reader) {
        this.reader = reader;
    }

    public String[] readLine() {
        if (this.endOfFile) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean startOfLine = true;
        while (!this.endOfLine && !this.endOfFile) {
            String cell = this.readCell();
            if (startOfLine) {
                if (this.endOfFile && cell.length() == 0) {
                    return null;
                }
                startOfLine = false;
            }
            list.add(cell);
        }
        this.endOfLine = false;
        return list.toArray(new String[list.size()]);
    }

    private String readCell() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            boolean processThisCharacter = false;
            boolean hadQuote = false;
            int read = -1;
            block14: while (processThisCharacter || (read = this.reader.read()) != -1) {
                processThisCharacter = false;
                char character = (char)read;
                switch (character) {
                    case '\"': {
                        if (!hadQuote) {
                            hadQuote = true;
                            continue block14;
                        }
                        read = this.reader.read();
                        if (read == -1) {
                            this.endOfFile = true;
                            break block14;
                        }
                        character = (char)read;
                        switch (character) {
                            case '\"': {
                                stringBuilder.append(character);
                                continue block14;
                            }
                        }
                        hadQuote = false;
                        processThisCharacter = true;
                        continue block14;
                    }
                    case '\r': {
                        if (hadQuote) {
                            stringBuilder.append(character);
                            continue block14;
                        }
                        read = this.reader.read();
                        if (read == -1) {
                            this.endOfFile = true;
                            break block14;
                        }
                        character = (char)read;
                        switch (character) {
                            case '\n': {
                                this.endOfLine = true;
                                break block14;
                            }
                        }
                        stringBuilder.append('\r');
                        processThisCharacter = true;
                        continue block14;
                    }
                    case '\n': {
                        if (hadQuote) {
                            stringBuilder.append(character);
                            continue block14;
                        }
                        this.endOfLine = true;
                        break block14;
                    }
                    case ',': {
                        if (!hadQuote) break block14;
                        stringBuilder.append(character);
                        continue block14;
                    }
                    default: {
                        stringBuilder.append(character);
                        continue block14;
                    }
                }
            }
            if (read == -1) {
                this.endOfFile = true;
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

