/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    private static final Logger logger = LoggerFactory.getLogger(GenericsUtils.class);

    private GenericsUtils() {
    }

    public static boolean isGenericInterfaceAssignableFrom(Class<?> cls, Class<?> assignable, Class<?> rawType) {
        Type genericType = GenericsUtils.getGenericInterfaceParamType(assignable, rawType);
        return genericType == null || GenericsUtils.isAssignableFrom(genericType, cls);
    }

    public static boolean isAssignableFrom(Type type, Class<?> cls) {
        Class<?> classType;
        if (cls.isArray()) {
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArray = (GenericArrayType)type;
                Class<?> componentType = cls.getComponentType();
                return GenericsUtils.isAssignableFrom(genericArray.getGenericComponentType(), componentType);
            }
        } else if (!(type instanceof GenericArrayType) && ((classType = GenericsUtils.getClassType(type, null)) == Object.class || classType.isAssignableFrom(cls))) {
            return true;
        }
        return false;
    }

    public static Type getGenericInterfaceParamType(Class<?> cls, Class<?> rawType) {
        while (cls != null) {
            Type[] interfaces;
            for (Type type : interfaces = cls.getGenericInterfaces()) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    if (pType.getRawType() != rawType) continue;
                    return pType.getActualTypeArguments()[0];
                }
                Type interfaceType = GenericsUtils.getGenericInterfaceParamType((Class)type, rawType);
                if (interfaceType == null) continue;
                return interfaceType;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Class<?> getClassType(Type type, Class<?> context) {
        Class<?> cls;
        if (type == null) {
            return null;
        }
        Class<?> clazz = cls = context == null ? TypeFactory.type(type).getRawClass() : TypeFactory.type(type, context).getRawClass();
        if (cls != null) {
            return cls;
        }
        logger.error(Messages.getMessage("methodCannotHandleType", String.valueOf(type)));
        return null;
    }

    public static Class<?> getGenericParamType(Type type) {
        Class generic = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            generic = (Class)actualTypeArguments[0];
        }
        return generic;
    }
}

