/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.09.15 at 01:17:47 PM IDT 
//

package org.apache.wink.common.model.opensearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * The "Url" element per OpenSearch specification
 * 
 * <pre>
 * The &quot;Url&quot; element
 *     
 *     Describes an interface by which a search client can make search requests of the search engine.
 *     
 *     OpenSearch provides support for both index-based and page-based search engines. By default, both the first search result and the first page of search results are numbered &quot;1&quot;. Search engines can use the &quot;indexOffset&quot; and &quot;pageOffset&quot; attributes to inform search clients of different starting values.
 *     
 *         Parent: OpenSearchDescription 
 *         Attributes:
 *     
 *             template - Contains the search URL template to be processed according to the OpenSearch URL template syntax.
 *     
 *                 Requirements: This attribute is required. 
 *     
 *             type - Contains the MIME type of the search result format.
 *     
 *                 Restrictions: The value must be a valid MIME type. 
 *                 Requirements: This attribute is required. 
 *     
 *             indexOffset - Contains the index number of the first search result.
 *     
 *                 Restrictions: The value must be an integer. 
 *                 Default: &quot;1&quot; 
 *                 Requirements: This attribute is optional. 
 *     
 *             pageOffset - Contains the page number of the first set of search results.
 *     
 *                 Restrictions: The value must be an integer. 
 *                 Default: &quot;1&quot;. 
 *                 Requirements: This attribute is optional. 
 *     
 *         Requirements: This element must appear one or more times. 
 *     
 *     
 *     Example of a Url element describing the interface used to retrieve search results over RSS:
 *     
 *      &lt;Url type=&quot;application/rss+xml&quot;
 *           template=&quot;http://example.com/?q={searchTerms}&amp;pw={startPage?}&quot; /&gt;
 *     
 *     Example of a Url element describing the interface used to retrieve 0-based search results over XHTML:
 *     
 *      &lt;Url type=&quot;application/xhtml+xml&quot;
 *           indexOffset=&quot;0&quot;
 *           template=&quot;http://example.com/search?q={searchTerms}&amp;start={startIndex?}&quot; /&gt;
 * 
 * </pre>
 */
@XmlAccessorType(XmlAccessType.NONE)
@XmlType(name = "OpenSearchUrl")
public class OpenSearchUrl {

    // MimeType
    protected String                  type;
    // OpenSearch URL template
    protected String                  template;

    // List of OpenSearch parameters
    @XmlTransient
    private List<OpenSearchParameter> openSearchParameters;
    // Parameter delimiter
    @XmlTransient
    private static final String       paramDelimiter  = "&"; //$NON-NLS-1$
    // Search parameters delimiter
    @XmlTransient
    private static final String       searchDelimiter = "?"; //$NON-NLS-1$
    // Base URI
    @XmlTransient
    private String                    baseUri;

    /**
     * Gets the value of the type property.
     * 
     * @return possible object is {@link String }
     */
    @XmlAttribute
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the template property.
     * 
     * @return possible object is {@link String }
     */
    @XmlAttribute
    public String getTemplate() {
        if (template != null) {
            return template;
        } else
            return generateOpenSearchUrlTemplate();
    }

    /**
     * Sets the value of the template property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setTemplate(String value) {
        this.template = value;
    }

    /**
     * Add OpenSearch parameter to the list of Open Search Parameters
     * 
     * @param openSearchParameter allowed object is {@link OpenSearchParameter}
     */
    public void addOpenSearchParameter(OpenSearchParameter openSearchParameter) {
        getOpenSearchParameters().add(openSearchParameter);
    }

    /**
     * Gets the value of the openSearchParameters property.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside openSearchParameters object.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getOpenSearchParameters().add(openSearchParameter);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link String}
     */
    public List<OpenSearchParameter> getOpenSearchParameters() {
        if (openSearchParameters == null) {
            openSearchParameters = new ArrayList<OpenSearchParameter>();
        }
        return openSearchParameters;
    }

    /**
     * Builds OpenSearchUrl template based on base URI and the list of Open
     * Search openSearchParametersParameters
     * 
     * @return String OpenSearchUrl template
     */
    public String generateOpenSearchUrlTemplate() {

        String paramList = searchDelimiter;
        if (openSearchParameters == null)
            return ""; //$NON-NLS-1$

        // Use Iterator to avoid redundant & in the end of search parameters
        // list
        Iterator<OpenSearchParameter> itr = openSearchParameters.iterator();

        if (!itr.hasNext())
            return ""; //$NON-NLS-1$

        OpenSearchParameter openSearchParameter = itr.next();
        paramList = paramList + openSearchParameter.getURLParameter();

        while (itr.hasNext()) {
            paramList = paramList + paramDelimiter;
            openSearchParameter = itr.next();
            paramList = paramList + openSearchParameter.getURLParameter();

        }

        template = baseUri + paramList;

        return template;
    }

    /**
     * Get Search base URI
     * 
     * @return String
     */
    public String getBaseUri() {
        return baseUri;
    }

    /**
     * Set Search base URI
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

}
