/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyUtils {
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static String fFullPropertyFileName = null;
    private static Properties fProperties;

    public static String findProperty(String propertyName) {
        String propertyValue = null;
        try {
            propertyValue = System.getProperty(propertyName);
            if (propertyValue != null) {
                return propertyValue;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (fProperties == null) {
            fProperties = new Properties();
            String propFileName = PropertyUtils.getFullPropertyFileName();
            if (propFileName != null) {
                try {
                    File propFile = new File(propFileName);
                    FileInputStream fis = new FileInputStream(propFile);
                    fProperties.load(fis);
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((propertyValue = fProperties.getProperty(propertyName)) != null) {
            return propertyValue;
        }
        return null;
    }

    private static String getFullPropertyFileName() {
        if (fFullPropertyFileName == null) {
            try {
                String javaHome = System.getProperty("java.home");
                fFullPropertyFileName = javaHome + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fFullPropertyFileName;
    }
}

