/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragmentSupport;
import org.apache.axiom.core.CoreDocumentSupport;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DeferringParentNodeSupport;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMDocumentSupport;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.common.IDocument;
import org.apache.axiom.om.impl.common.INode;
import org.apache.axiom.om.impl.common.OMContainerSupport;
import org.apache.axiom.om.impl.common.OMDocumentHelper;
import org.apache.axiom.om.impl.common.OMDocumentSupport;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.OMSerializableSupport;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.common.serializer.push.stax.StAXSerializer;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CDATASectionImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMContainer;
import org.apache.axiom.om.impl.dom.DOMContainerSupport;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.EntityReferenceImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.RootNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends RootNode
implements DOMDocument,
IDocument,
DOMContainer {
    private String xmlVersion;
    private String xmlEncoding;
    private boolean xmlStandalone;
    private String charEncoding;
    private Vector idAttrs;
    protected Hashtable identifiers;
    public DOMConfigurationImpl domConfig;
    public OMXMLParserWrapper builder;

    public DocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        DeferringParentNodeSupport.ajc$interFieldInit$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder(this);
        DOMDocumentSupport.ajc$interFieldInit$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$domConfig(this);
        this.xmlStandalone = false;
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, parserWrapper);
    }

    public DocumentImpl(OMFactory factory) {
        super(factory);
        DeferringParentNodeSupport.ajc$interFieldInit$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder(this);
        DOMDocumentSupport.ajc$interFieldInit$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$domConfig(this);
        this.xmlStandalone = false;
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, 1);
    }

    public Document getOwnerDocument() {
        return null;
    }

    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        this.internalSerialize(serializer, format, cache, !format.isIgnoreXMLDeclaration());
    }

    public Attr createAttribute(String name) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        return new AttrImpl(this, name, this.getOMFactory());
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        DOMUtil.validateAttrName(namespaceURI, localName, prefix);
        OMNamespaceImpl namespace = namespaceURI == null ? null : new OMNamespaceImpl(namespaceURI, prefix == null ? "" : prefix);
        return new AttrImpl(this, localName, namespace, this.getOMFactory());
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        CDATASectionImpl cdataSection = new CDATASectionImpl(data, this.getOMFactory());
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(cdataSection, this);
        return cdataSection;
    }

    public Comment createComment(String data) {
        CommentImpl comment = new CommentImpl(data, this.getOMFactory());
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(comment, this);
        return comment;
    }

    public DocumentFragment createDocumentFragment() {
        DocumentFragmentImpl fragment = new DocumentFragmentImpl(this.getOMFactory());
        CoreDocumentFragmentSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreDocumentFragmentSupport$org_apache_axiom_core_CoreDocumentFragment$coreSetOwnerDocument(fragment, this);
        return fragment;
    }

    public Element createElement(String tagName) throws DOMException {
        ElementImpl element = new ElementImpl(null, tagName, null, null, this.getOMFactory(), false);
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(element, this);
        return element;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        DOMUtil.validateElementName(namespaceURI, localName, prefix);
        OMNamespaceImpl namespace = namespaceURI == null ? null : new OMNamespaceImpl(namespaceURI, prefix == null ? "" : prefix);
        ElementImpl element = new ElementImpl(null, localName, namespace, null, this.getOMFactory(), false);
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(element, this);
        return element;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        EntityReferenceImpl node = new EntityReferenceImpl(name, null, this.getOMFactory());
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(node, this);
        return node;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(target, data, this.getOMFactory());
        CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreSetOwnerDocument(pi, this);
        return pi;
    }

    public DocumentType getDoctype() {
        Iterator it = OMContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getChildren((OMContainer)this);
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof DocumentType) {
                return (DocumentType)child;
            }
            if (!(child instanceof Element)) continue;
            return null;
        }
        return null;
    }

    public Element getElementById(String elementId) {
        if (this.idAttrs == null) {
            return null;
        }
        Enumeration attrEnum = this.idAttrs.elements();
        while (attrEnum.hasMoreElements()) {
            Attr tempAttr = (Attr)attrEnum.nextElement();
            if (!tempAttr.getValue().equals(elementId)) continue;
            return tempAttr.getOwnerElement();
        }
        return null;
    }

    public DOMImplementation getImplementation() {
        return ((DOMMetaFactory)this.getOMFactory().getMetaFactory()).getDOMImplementation();
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    int index = 0;
                    while (index < length) {
                        Attr newAttr;
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                            newAttr = (Attr)this.importNode(attr, true);
                            newElement.setAttributeNodeNS(newAttr);
                        } else {
                            newAttr = (Attr)this.importNode(attr, true);
                            newElement.setAttributeNode(newAttr);
                        }
                        ++index;
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if ("".equals(importedNode.getNamespaceURI()) || importedNode.getNamespaceURI() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else if ("xmlns".equals(importedNode.getNodeName())) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = DOMDocumentSupport.ajc$interMethodDispatch1$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$createTextNode(this, importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: {
                newNode = this.createCDATASection(importedNode.getNodeValue());
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                throw DOMExceptionUtil.newDOMException((short)9);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            Node srckid = importedNode.getFirstChild();
            while (srckid != null) {
                newNode.appendChild(this.importNode(srckid, true));
                srckid = srckid.getNextSibling();
            }
        }
        return newNode;
    }

    public String getCharsetEncoding() {
        return this.charEncoding;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public String isStandalone() {
        return this.xmlStandalone ? "yes" : "no";
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charEncoding = charsetEncoding;
    }

    public void setOMDocumentElement(OMElement documentElement) {
        if (documentElement == null) {
            throw new IllegalArgumentException("documentElement must not be null");
        }
        OMElement existingDocumentElement = OMDocumentSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMDocumentSupport$org_apache_axiom_om_impl_common_IDocument$getOMDocumentElement(this);
        if (existingDocumentElement == null) {
            OMContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$addChild(this, (OMNode)documentElement);
        } else {
            OMNode nextSibling = existingDocumentElement.getNextOMSibling();
            existingDocumentElement.detach();
            if (nextSibling == null) {
                OMContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$addChild(this, (OMNode)documentElement);
            } else {
                nextSibling.insertSiblingBefore((OMNode)documentElement);
            }
        }
    }

    public void setStandalone(String isStandalone) {
        this.xmlStandalone = "yes".equalsIgnoreCase(isStandalone);
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        try {
            this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, false);
        }
        catch (OutputException ex) {
            throw (XMLStreamException)ex.getCause();
        }
        writer.flush();
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        try {
            this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, true);
        }
        catch (OutputException ex) {
            throw (XMLStreamException)ex.getCause();
        }
        writer.flush();
    }

    public void setXMLVersion(String version) {
        this.xmlVersion = version;
    }

    public String getXMLEncoding() {
        return this.xmlEncoding;
    }

    public void setXMLEncoding(String encoding) {
        this.xmlEncoding = encoding;
    }

    protected void addIdAttr(Attr attr) {
        if (this.idAttrs == null) {
            this.idAttrs = new Vector();
        }
        this.idAttrs.add(attr);
    }

    protected void removeIdAttr(Attr attr) {
        if (this.idAttrs != null) {
            this.idAttrs.remove(attr);
        }
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Node adoptNode(Node node) throws DOMException {
        if (node instanceof NodeImpl) {
            NodeImpl childNode = (NodeImpl)node;
            if (childNode instanceof CoreChildNode && CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreHasParent((CoreChildNode)((Object)childNode))) {
                ((OMNode)childNode).detach();
            }
            childNode.coreSetOwnerDocument(this);
            if (node instanceof AttrImpl) {
                ((AttrImpl)node).setSpecified(true);
            }
            return childNode;
        }
        return null;
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getInputEncoding() {
        return this.charEncoding;
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("TODO");
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public String getXmlVersion() {
        return this.getXMLVersion();
    }

    public Node renameNode(Node node, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("TODO");
    }

    public void setXmlStandalone(boolean standalone) throws DOMException {
        this.xmlStandalone = standalone;
    }

    public void setXmlVersion(String version) throws DOMException {
        this.setXMLVersion(version);
    }

    protected void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache, boolean includeXMLDeclaration) throws OutputException {
        OMDocumentHelper.internalSerialize(this, serializer, format, cache, includeXMLDeclaration);
    }

    ParentNode shallowClone(OMCloneOptions options, ParentNode targetParent, boolean namespaceRepairing) {
        DocumentImpl clone = options.isPreserveModel() ? this.createClone(options) : new DocumentImpl(this.getOMFactory());
        clone.xmlVersion = this.xmlVersion;
        clone.xmlEncoding = this.xmlEncoding;
        clone.xmlStandalone = this.xmlStandalone;
        clone.charEncoding = this.charEncoding;
        return clone;
    }

    protected DocumentImpl createClone(OMCloneOptions options) {
        return new DocumentImpl(this.getOMFactory());
    }

    public final void setComplete(boolean complete) {
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, complete ? 1 : 0);
    }

    public final void build() {
        OMContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$defaultBuild(this);
    }

    public final void checkChild(OMNode child) {
        if (child instanceof OMElement) {
            if (OMDocumentSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_OMDocumentSupport$org_apache_axiom_om_impl_common_IDocument$getOMDocumentElement(this) != null) {
                throw new OMException("Document element already exists");
            }
            this.checkDocumentElement((OMElement)child);
        }
    }

    protected void checkDocumentElement(OMElement element) {
    }

    public final void setPrefix(String prefix) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    public /* synthetic */ DOMConfigurationImpl ajc$interFieldGet$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$domConfig() {
        return this.domConfig;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$domConfig(DOMConfigurationImpl dOMConfigurationImpl) {
        this.domConfig = dOMConfigurationImpl;
    }

    public /* synthetic */ OMXMLParserWrapper ajc$interFieldGet$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder() {
        return this.builder;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$builder(OMXMLParserWrapper oMXMLParserWrapper) {
        this.builder = oMXMLParserWrapper;
    }

    public void addChild(OMNode oMNode) {
        OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$addChild(this, oMNode);
    }

    public void addChild(OMNode oMNode, boolean bl) {
        OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$addChild(this, oMNode, bl);
    }

    public /* synthetic */ CoreNode ajc$interMethodDispatch2$org_apache_axiom_core$getRootOrOwnerDocument() {
        return CoreDocumentSupport.ajc$interMethod$org_apache_axiom_core_CoreDocumentSupport$org_apache_axiom_core_CoreDocument$getRootOrOwnerDocument(this);
    }

    public /* synthetic */ void ajc$interMethodDispatch2$org_apache_axiom_om_impl_dom$notifyChildComplete() {
        DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$notifyChildComplete(this);
    }

    public /* synthetic */ NodeList ajc$interMethodDispatch2$org_apache_axiom_om_impl_dom_DOMContainerSupport$getElementsWildcard() {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsWildcard(this);
    }

    public void close(boolean bl) {
        OMSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMSerializableSupport$org_apache_axiom_om_impl_common_ISerializable$close(this, bl);
    }

    public final CoreElement coreGetDocumentElement() {
        return CoreDocumentSupport.ajc$interMethod$org_apache_axiom_core_CoreDocumentSupport$org_apache_axiom_core_CoreDocument$coreGetDocumentElement(this);
    }

    public final void coreSetBuilder(OMXMLParserWrapper oMXMLParserWrapper) {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, oMXMLParserWrapper);
    }

    public final void coreSetOwnerDocument(CoreDocument coreDocument) {
        CoreDocumentSupport.ajc$interMethod$org_apache_axiom_core_CoreDocumentSupport$org_apache_axiom_core_CoreDocument$coreSetOwnerDocument(this, coreDocument);
    }

    public final void coreSetState(int n) {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetState(this, n);
    }

    public final Text createTextNode(String string) {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$createTextNode(this, string);
    }

    public void defaultBuild() {
        OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$defaultBuild(this);
    }

    public final void discarded() {
        OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$discarded(this);
    }

    public void forceExpand() {
        DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$forceExpand(this);
    }

    public final OMXMLParserWrapper getBuilder() {
        return DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getBuilder(this);
    }

    public Iterator getChildren() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getChildren((OMContainer)this);
    }

    public Iterator getChildrenWithLocalName(String string) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithLocalName((OMContainer)this, string);
    }

    public Iterator getChildrenWithName(QName qName) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithName((OMContainer)this, qName);
    }

    public Iterator getChildrenWithNamespaceURI(String string) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithNamespaceURI((OMContainer)this, string);
    }

    public Iterator getDescendants(boolean bl) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_OMContainer$getDescendants((OMContainer)this, bl);
    }

    public final Element getDocumentElement() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getDocumentElement(this);
    }

    public final DOMConfiguration getDomConfig() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getDomConfig(this);
    }

    public final NodeList getElementsByTagName(String string) {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsByTagName(this, string);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        return DOMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_dom_DOMContainerSupport$org_apache_axiom_om_impl_dom_DOMContainer$getElementsByTagNameNS(this, string, string2);
    }

    public OMElement getFirstChildWithName(QName qName) throws OMException {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getFirstChildWithName(this, qName);
    }

    public OMNode getFirstOMChild() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getFirstOMChild(this);
    }

    public OMNode getFirstOMChildIfAvailable() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getFirstOMChildIfAvailable(this);
    }

    public final String getLocalName() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getLocalName(this);
    }

    public final String getNodeName() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getNodeName(this);
    }

    public final short getNodeType() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getNodeType(this);
    }

    public final String getNodeValue() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getNodeValue(this);
    }

    public final OMElement getOMDocumentElement() {
        return OMDocumentSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMDocumentSupport$org_apache_axiom_om_impl_common_IDocument$getOMDocumentElement(this);
    }

    public final String getPrefix() {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$getPrefix(this);
    }

    public SAXResult getSAXResult() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getSAXResult(this);
    }

    public final SAXSource getSAXSource(boolean bl) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getSAXSource(this, bl);
    }

    public int getState() {
        return DeferringParentNodeSupport.ajc$interMethod$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getState(this);
    }

    public XMLStreamReader getXMLStreamReader() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getXMLStreamReader(this);
    }

    public XMLStreamReader getXMLStreamReader(boolean bl) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getXMLStreamReader(this, bl);
    }

    public XMLStreamReader getXMLStreamReader(boolean bl, OMXMLStreamReaderConfiguration oMXMLStreamReaderConfiguration) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getXMLStreamReader(this, bl, oMXMLStreamReaderConfiguration);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$getXMLStreamReaderWithoutCaching(this);
    }

    public boolean isComplete() {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$isComplete(this);
    }

    public final String lookupNamespaceURI(String string) {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$lookupNamespaceURI(this, string);
    }

    public final String lookupPrefix(String string) {
        return DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$lookupPrefix(this, string);
    }

    public final void normalizeDocument() {
        DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$normalizeDocument(this);
    }

    public final INode prepareNewChild(OMNode oMNode) {
        return OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$prepareNewChild(this, oMNode);
    }

    public void removeChildren() {
        OMContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMContainerSupport$org_apache_axiom_om_impl_common_IContainer$removeChildren(this);
    }

    public final void setNodeValue(String string) {
        DOMDocumentSupport.ajc$interMethod$org_apache_axiom_dom_DOMDocumentSupport$org_apache_axiom_dom_DOMDocument$setNodeValue(this, string);
    }
}

