/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.impl.common.factory.DOMXMLStreamReader;
import org.apache.axiom.om.impl.common.factory.SAXOMBuilder;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.OMMetaFactoryEx;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.axiom.util.stax.XMLFragmentStreamReader;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractOMMetaFactory
implements OMMetaFactoryEx {
    private static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, InputSource is) {
        try {
            if (is.getByteStream() != null) {
                String systemId = is.getSystemId();
                String encoding = is.getEncoding();
                if (systemId != null) {
                    if (encoding == null) {
                        return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (String)systemId, (InputStream)is.getByteStream());
                    }
                    throw new UnsupportedOperationException();
                }
                if (encoding == null) {
                    return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (InputStream)is.getByteStream());
                }
                return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (InputStream)is.getByteStream(), (String)encoding);
            }
            if (is.getCharacterStream() != null) {
                return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (Reader)is.getCharacterStream());
            }
            String systemId = is.getSystemId();
            return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (String)systemId, (InputStream)new URL(systemId).openConnection().getInputStream());
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    private static XMLStreamReader getXMLStreamReader(XMLStreamReader originalReader) {
        int eventType = originalReader.getEventType();
        switch (eventType) {
            case 7: {
                return originalReader;
            }
            case 1: {
                return new XMLFragmentStreamReader(originalReader);
            }
        }
        throw new OMException("The supplied XMLStreamReader is in an unexpected state (" + XMLEventUtils.getEventTypeString((int)eventType) + ")");
    }

    public OMXMLParserWrapper createStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        return new StAXOMBuilder(omFactory, AbstractOMMetaFactory.getXMLStreamReader(parser));
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputSource is) {
        StAXOMBuilder builder = new StAXOMBuilder(omFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, is));
        builder.setAutoClose(true);
        return builder;
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Source source) {
        if (source instanceof SAXSource) {
            return this.createOMBuilder(omFactory, (SAXSource)source, true);
        }
        if (source instanceof DOMSource) {
            return this.createOMBuilder(omFactory, ((DOMSource)source).getNode(), true);
        }
        try {
            return new StAXOMBuilder(omFactory, StAXUtils.getXMLInputFactory().createXMLStreamReader(source));
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Node node, boolean expandEntityReferences) {
        return new StAXOMBuilder(omFactory, (XMLStreamReader)((Object)new DOMXMLStreamReader(node, expandEntityReferences)));
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, SAXSource source, boolean expandEntityReferences) {
        return new SAXOMBuilder(omFactory, source, expandEntityReferences);
    }

    public OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, OMFactory omFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        XOPAwareStAXOMBuilder builder = new XOPAwareStAXOMBuilder(omFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart), mimePartProvider);
        builder.setAutoClose(true);
        return builder;
    }

    public SOAPModelBuilder createStAXSOAPModelBuilder(XMLStreamReader parser) {
        return new StAXSOAPModelBuilder((OMMetaFactory)this, AbstractOMMetaFactory.getXMLStreamReader(parser));
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, InputSource is) {
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder((OMMetaFactory)this, AbstractOMMetaFactory.createXMLStreamReader(configuration, is));
        builder.setAutoClose(true);
        return builder;
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, SOAPFactory soapFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        MTOMStAXSOAPModelBuilder builder = new MTOMStAXSOAPModelBuilder(soapFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart), mimePartProvider);
        builder.setAutoClose(true);
        return builder;
    }
}

