/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.Detachable;

final class DetachableReader
extends Reader
implements Detachable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private Reader target;

    DetachableReader(Reader target) {
        this.target = target;
    }

    public int read(CharBuffer target) throws IOException {
        return target.read(target);
    }

    public int read() throws IOException {
        return this.target.read();
    }

    public int read(char[] cbuf) throws IOException {
        return this.target.read(cbuf);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.target.read(cbuf, off, len);
    }

    public long skip(long n) throws IOException {
        return this.target.skip(n);
    }

    public boolean ready() throws IOException {
        return this.target.ready();
    }

    public void close() throws IOException {
        this.target.close();
    }

    public void detach() {
        MemoryBlob blob = Blobs.createMemoryBlob();
        OutputStreamWriter out = new OutputStreamWriter(blob.getOutputStream(), UTF8);
        char[] buffer = new char[2048];
        try {
            int c;
            while ((c = this.target.read(buffer)) != -1) {
                ((Writer)out).write(buffer, 0, c);
            }
            ((Writer)out).close();
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
        this.target = new InputStreamReader(blob.readOnce(), UTF8);
    }
}

