/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.core.NodeMigrationPolicy;
import org.apache.axiom.dom.DOMAttribute;

public final class Policies {
    public static final AttributeMatcher DOM1_ATTRIBUTE_MATCHER = new AttributeMatcher(){

        public boolean matches(CoreAttribute attr, String namespaceURI, String name) {
            return name.equals(((DOMAttribute)attr).getName());
        }

        public String getNamespaceURI(CoreAttribute attr) {
            return null;
        }

        public String getName(CoreAttribute attr) {
            return ((DOMAttribute)attr).getName();
        }

        public CoreAttribute createAttribute(NodeFactory nodeFactory, CoreDocument document, String namespaceURI, String name, String prefix, String value) {
            return nodeFactory.createAttribute(document, name, value, null);
        }

        public void update(CoreAttribute attr, String prefix, String value) {
            attr.coreSetValue(value);
        }
    };
    public static final AttributeMatcher DOM2_ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher(true, true);
    public static final NodeMigrationPolicy ATTRIBUTE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return NodeMigrationPolicy.Action.REJECT;
        }
    };
    public static final NodeMigrationPolicy NODE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return isForeignDocument ? NodeMigrationPolicy.Action.REJECT : NodeMigrationPolicy.Action.MOVE;
        }
    };

    private Policies() {
    }
}

