/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.CoreNSUnawareNamedNodeSupport;
import org.apache.axiom.core.NodeFactory;

public final class NSAwareAttributeMatcher
implements AttributeMatcher {
    private final boolean matchNSUnawareAttributes;
    private final boolean updatePrefix;

    public NSAwareAttributeMatcher(boolean matchNSUnawareAttributes, boolean updatePrefix) {
        this.matchNSUnawareAttributes = matchNSUnawareAttributes;
        this.updatePrefix = updatePrefix;
    }

    public boolean matches(CoreAttribute attr, String namespaceURI, String name) {
        if (attr instanceof CoreNSAwareAttribute) {
            CoreNSAwareAttribute nsAwareAttr = (CoreNSAwareAttribute)attr;
            return name.equals(nsAwareAttr.coreGetLocalName()) && namespaceURI.equals(nsAwareAttr.coreGetNamespaceURI());
        }
        if (this.matchNSUnawareAttributes && namespaceURI.length() == 0 && attr instanceof CoreNSUnawareAttribute) {
            return name.equals(CoreNSUnawareNamedNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreNSUnawareNamedNodeSupport$org_apache_axiom_core_CoreNSUnawareNamedNode$coreGetName((CoreNSUnawareAttribute)attr));
        }
        return false;
    }

    public String getNamespaceURI(CoreAttribute attr) {
        return ((CoreNSAwareAttribute)attr).coreGetNamespaceURI();
    }

    public String getName(CoreAttribute attr) {
        return ((CoreNSAwareAttribute)attr).coreGetLocalName();
    }

    public CoreAttribute createAttribute(NodeFactory nodeFactory, CoreDocument document, String namespaceURI, String name, String prefix, String value) {
        return nodeFactory.createAttribute(document, namespaceURI, name, prefix, value, null);
    }

    public void update(CoreAttribute attr, String prefix, String value) {
        attr.coreSetValue(value);
        if (this.updatePrefix && attr instanceof CoreNSAwareAttribute) {
            ((CoreNSAwareAttribute)attr).coreSetPrefix(prefix);
        }
    }
}

