/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreChildNodeSupport;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.ExceptionTranslator;
import org.apache.axiom.core.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeIterator<T>
implements NodeIterator<T> {
    private final CoreParentNode startNode;
    private final Axis axis;
    private final Class<T> type;
    private final ExceptionTranslator exceptionTranslator;
    private final DetachPolicy detachPolicy;
    private CoreNode currentNode;
    private CoreParentNode currentParent;
    private CoreNode nextNode;
    private boolean hasNext;
    private int depth;

    public AbstractNodeIterator(CoreParentNode startNode, Axis axis, Class<T> type, ExceptionTranslator exceptionTranslator, DetachPolicy detachPolicy) {
        this.startNode = startNode;
        this.axis = axis;
        this.type = type;
        this.exceptionTranslator = exceptionTranslator;
        this.detachPolicy = detachPolicy;
    }

    protected abstract boolean matches(CoreNode var1) throws CoreModelException;

    @Override
    public final boolean hasNext() {
        if (!this.hasNext) {
            CoreNode node = this.currentNode;
            if (node instanceof CoreChildNode && CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)node) != this.currentParent) {
                throw new ConcurrentModificationException("The current node has been removed using a method other than Iterator#remove()");
            }
            try {
                do {
                    block1 : switch (this.axis) {
                        case CHILDREN: {
                            if (node == null) {
                                node = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChild(this.startNode);
                                break;
                            }
                            node = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSibling((CoreChildNode)node);
                            break;
                        }
                        case DESCENDANTS: 
                        case DESCENDANTS_OR_SELF: {
                            if (node == null) {
                                if (this.axis == Axis.DESCENDANTS) {
                                    node = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChild(this.startNode);
                                    ++this.depth;
                                    break;
                                }
                                node = this.startNode;
                                break;
                            }
                            boolean visitChildren = true;
                            while (true) {
                                CoreChildNode firstChild;
                                if (visitChildren && node instanceof CoreElement && (firstChild = CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetFirstChild((CoreElement)node)) != null) {
                                    ++this.depth;
                                    node = firstChild;
                                    break block1;
                                }
                                if (this.depth == 0) {
                                    node = null;
                                    break block1;
                                }
                                CoreChildNode nextSibling = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetNextSibling((CoreChildNode)node);
                                if (nextSibling != null) {
                                    node = nextSibling;
                                    break block1;
                                }
                                --this.depth;
                                node = CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)node);
                                visitChildren = false;
                            }
                        }
                    }
                } while (node != null && !this.matches(node));
            }
            catch (CoreModelException ex) {
                throw this.exceptionTranslator.toUncheckedException(ex);
            }
            this.nextNode = node;
            this.hasNext = true;
        }
        return this.nextNode != null;
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            this.currentNode = this.nextNode;
            this.currentParent = this.currentNode instanceof CoreChildNode ? CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreGetParent((CoreChildNode)this.currentNode) : null;
            this.hasNext = false;
            return this.type.cast(this.currentNode);
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        if (this.currentNode == null) {
            throw new IllegalStateException();
        }
        this.hasNext();
        if (this.currentNode instanceof CoreChildNode) {
            CoreChildNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreChildNodeSupport$org_apache_axiom_core_CoreChildNode$coreDetach((CoreChildNode)this.currentNode, this.detachPolicy);
        }
        this.currentNode = null;
    }

    @Override
    public final void replace(CoreChildNode newNode) throws CoreModelException {
        throw new UnsupportedOperationException();
    }
}

