/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.IText;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.OMTextSupport;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMLeafNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.Base64Utils;

public class OMTextImpl
extends OMLeafNode
implements OMText,
OMConstants,
IText {
    private final int nodeType;
    protected String value;
    protected char[] charArray;
    protected String mimeType;
    private String contentID;
    private Object dataHandlerObject;
    private static final String EMTPY_STRING = "";
    public boolean optimize;
    public boolean binary;

    public OMTextImpl(String s, OMFactory factory) {
        this(s, 4, factory);
    }

    public OMTextImpl(String s, int nodeType, OMFactory factory) {
        this(null, s, nodeType, factory, false);
    }

    public OMTextImpl(OMContainer parent, String text, OMFactory factory) {
        this(parent, text, 4, factory, false);
    }

    public OMTextImpl(OMContainer parent, OMTextImpl source, OMFactory factory) {
        super(parent, factory, false);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.value = source.value;
        this.nodeType = source.nodeType;
        if (source.charArray != null) {
            this.charArray = new char[source.charArray.length];
            System.arraycopy(source.charArray, 0, this.charArray, 0, source.charArray.length);
        }
        this.setOptimize(source.isOptimized());
        this.mimeType = source.mimeType;
        this.setBinary(source.isBinary());
        this.contentID = source.contentID;
        this.dataHandlerObject = source.dataHandlerObject;
    }

    public OMTextImpl(OMContainer parent, String text, int nodeType, OMFactory factory, boolean fromBuilder) {
        super(parent, factory, fromBuilder);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.value = text == null ? EMTPY_STRING : text;
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, char[] charArray, int nodeType, OMFactory factory) {
        super(parent, factory, false);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.charArray = charArray;
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public OMTextImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        super(parent, factory, false);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        OMNamespace textNS = ((OMElementImpl)parent).handleNamespace(text.getNamespaceURI(), text.getPrefix());
        this.value = textNS == null ? text.getLocalPart() : String.valueOf(textNS.getPrefix()) + ":" + text.getLocalPart();
        this.nodeType = nodeType;
    }

    public OMTextImpl(String s, String mimeType, boolean optimize, OMFactory factory) {
        this(null, s, mimeType, optimize, factory);
    }

    public OMTextImpl(OMContainer parent, String s, String mimeType, boolean optimize, OMFactory factory) {
        this(parent, s, factory);
        this.mimeType = mimeType;
        this.setOptimize(optimize);
        this.setBinary(true);
    }

    public OMTextImpl(Object dataHandler, OMFactory factory) {
        this(null, dataHandler, true, factory, false);
    }

    public OMTextImpl(OMContainer parent, Object dataHandler, boolean optimize, OMFactory factory, boolean fromBuilder) {
        super(parent, factory, fromBuilder);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.dataHandlerObject = dataHandler;
        this.setBinary(true);
        this.setOptimize(optimize);
        this.nodeType = 4;
    }

    public OMTextImpl(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize, OMFactory factory) {
        super(factory);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(this);
        OMTextSupport.ajc$interFieldInit$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(this);
        this.contentID = contentID;
        this.dataHandlerObject = dataHandlerProvider;
        this.setBinary(true);
        this.setOptimize(optimize);
        this.nodeType = 4;
    }

    public final int getType() {
        return this.nodeType;
    }

    public String getText() throws OMException {
        if (this.charArray != null || this.value != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return Base64Utils.encode((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public char[] getTextCharacters() {
        if (this.charArray != null) {
            return this.charArray;
        }
        if (this.value != null) {
            return this.value.toCharArray();
        }
        try {
            return Base64Utils.encodeToCharArray((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.value;
    }

    public QName getTextAsQName() throws OMException {
        return ((OMElement)this.getParent()).resolveQName(this.getTextFromProperPlace());
    }

    public OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    public Object getDataHandler() {
        if ((this.value != null || this.charArray != null) && this.isBinary()) {
            String text = this.getTextFromProperPlace();
            return DataHandlerUtils.getDataHandlerFromText((String)text, (String)this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            throw new OMException("No DataHandler available");
        }
        if (this.dataHandlerObject instanceof DataHandlerProvider) {
            try {
                this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.dataHandlerObject;
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        if (!this.isBinary()) {
            serializer.writeText(this.getType(), this.getText());
        } else if (this.dataHandlerObject instanceof DataHandlerProvider) {
            serializer.writeDataHandler((DataHandlerProvider)this.dataHandlerObject, this.contentID, this.isOptimized());
        } else {
            serializer.writeDataHandler((DataHandler)this.getDataHandler(), this.contentID, this.isOptimized());
        }
    }

    public void buildWithAttachments() {
        if (this.isOptimized()) {
            ((DataHandler)this.getDataHandler()).getDataSource();
        }
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }

    OMNode clone(OMCloneOptions options, OMContainer targetParent) {
        if (this.isBinary() && options.isFetchDataHandlers()) {
            ((DataHandler)this.getDataHandler()).getDataSource();
        }
        return this.getOMFactory().createOMText(targetParent, (OMText)this);
    }

    public /* synthetic */ boolean ajc$interFieldGet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize() {
        return this.optimize;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$optimize(boolean bl) {
        this.optimize = bl;
    }

    public /* synthetic */ boolean ajc$interFieldGet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary() {
        return this.binary;
    }

    public /* synthetic */ void ajc$interFieldSet$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$binary(boolean bl) {
        this.binary = bl;
    }

    public final boolean isBinary() {
        return OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$isBinary(this);
    }

    public final boolean isOptimized() {
        return OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$isOptimized(this);
    }

    public final void setBinary(boolean bl) {
        OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$setBinary(this, bl);
    }

    public final void setOptimize(boolean bl) {
        OMTextSupport.ajc$interMethod$org_apache_axiom_om_impl_common_OMTextSupport$org_apache_axiom_om_impl_common_IText$setOptimize(this, bl);
    }
}

