/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.core.CharacterData;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMException;
import org.apache.axiom.util.base64.Base64Utils;

public final class TextContent
implements CharacterData {
    final String value;
    final String mimeType;
    String contentID;
    Object dataHandlerObject;
    boolean optimize;
    boolean binary;

    TextContent(String value) {
        this.value = value;
        this.mimeType = null;
    }

    public TextContent(String value, String mimeType, boolean optimize) {
        this.value = value;
        this.mimeType = mimeType;
        this.binary = true;
        this.optimize = optimize;
    }

    public TextContent(Object dataHandlerObject, boolean optimize) {
        this.value = null;
        this.mimeType = null;
        this.dataHandlerObject = dataHandlerObject;
        this.binary = true;
        this.optimize = optimize;
    }

    public TextContent(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        this.value = null;
        this.mimeType = null;
        this.dataHandlerObject = dataHandlerProvider;
        this.binary = true;
        this.optimize = optimize;
    }

    TextContent(TextContent other) {
        this.value = other.value;
        this.mimeType = other.mimeType;
        this.contentID = other.contentID;
        this.dataHandlerObject = other.dataHandlerObject;
        this.optimize = other.optimize;
        this.binary = other.binary;
    }

    DataHandler getDataHandler() {
        if (this.dataHandlerObject != null) {
            if (this.dataHandlerObject instanceof DataHandlerProvider) {
                try {
                    this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
                }
                catch (IOException ex) {
                    throw new OMException((Throwable)ex);
                }
            }
            return (DataHandler)this.dataHandlerObject;
        }
        if (this.binary) {
            return new DataHandler((DataSource)new ByteArrayDataSource(Base64Utils.decode((String)this.value), this.mimeType));
        }
        throw new OMException("No DataHandler available");
    }

    public String toString() {
        if (this.dataHandlerObject != null) {
            try {
                return Base64Utils.encode((DataHandler)this.getDataHandler());
            }
            catch (Exception e) {
                throw new OMException((Throwable)e);
            }
        }
        return this.value;
    }

    char[] toCharArray() {
        if (this.dataHandlerObject != null) {
            try {
                return Base64Utils.encodeToCharArray((DataHandler)this.getDataHandler());
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.value.toCharArray();
    }
}

