/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common;

import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.common.AxiomSOAP11Body;
import org.apache.axiom.soap.impl.common.AxiomSOAP11Fault;
import org.apache.axiom.soap.impl.common.AxiomSOAP11FaultCode;
import org.apache.axiom.soap.impl.common.AxiomSOAP11FaultDetail;
import org.apache.axiom.soap.impl.common.AxiomSOAP11FaultReason;
import org.apache.axiom.soap.impl.common.AxiomSOAP11FaultRole;
import org.apache.axiom.soap.impl.common.AxiomSOAP11Header;
import org.apache.axiom.soap.impl.common.AxiomSOAP11HeaderBlock;
import org.apache.axiom.soap.impl.common.AxiomSOAP12Body;
import org.apache.axiom.soap.impl.common.AxiomSOAP12Fault;
import org.apache.axiom.soap.impl.common.AxiomSOAP12FaultCode;
import org.apache.axiom.soap.impl.common.AxiomSOAP12FaultDetail;
import org.apache.axiom.soap.impl.common.AxiomSOAP12FaultReason;
import org.apache.axiom.soap.impl.common.AxiomSOAP12FaultRole;
import org.apache.axiom.soap.impl.common.AxiomSOAP12Header;
import org.apache.axiom.soap.impl.common.AxiomSOAP12HeaderBlock;
import org.apache.axiom.soap.impl.common.AxiomSOAPBody;
import org.apache.axiom.soap.impl.common.AxiomSOAPFault;
import org.apache.axiom.soap.impl.common.AxiomSOAPFaultCode;
import org.apache.axiom.soap.impl.common.AxiomSOAPFaultDetail;
import org.apache.axiom.soap.impl.common.AxiomSOAPFaultReason;
import org.apache.axiom.soap.impl.common.AxiomSOAPFaultRole;
import org.apache.axiom.soap.impl.common.AxiomSOAPHeader;
import org.apache.axiom.soap.impl.common.AxiomSOAPHeaderBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SOAPHelper {
    static final SOAPHelper SOAP11 = new SOAPHelper((SOAPVersion)SOAP11Version.getSingleton(), "SOAP 1.1", AxiomSOAP11Header.class, AxiomSOAP11HeaderBlock.class, AxiomSOAP11Body.class, AxiomSOAP11Fault.class, AxiomSOAP11FaultCode.class, AxiomSOAP11FaultReason.class, AxiomSOAP11FaultRole.class, AxiomSOAP11FaultDetail.class, "actor", null){

        public Boolean parseBoolean(String literal) {
            if (literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return value ? "1" : "0";
        }
    };
    static final SOAPHelper SOAP12 = new SOAPHelper((SOAPVersion)SOAP12Version.getSingleton(), "SOAP 1.2", AxiomSOAP12Header.class, AxiomSOAP12HeaderBlock.class, AxiomSOAP12Body.class, AxiomSOAP12Fault.class, AxiomSOAP12FaultCode.class, AxiomSOAP12FaultReason.class, AxiomSOAP12FaultRole.class, AxiomSOAP12FaultDetail.class, "role", "relay"){

        public Boolean parseBoolean(String literal) {
            if (literal.equals("true") || literal.equals("1")) {
                return Boolean.TRUE;
            }
            if (literal.equals("false") || literal.equals("0")) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String formatBoolean(boolean value) {
            return String.valueOf(value);
        }
    };
    private final SOAPVersion version;
    private final String specName;
    private final Class<? extends AxiomSOAPHeader> headerClass;
    private final QName headerQName;
    private final Class<? extends AxiomSOAPHeaderBlock> headerBlockClass;
    private final Class<? extends AxiomSOAPBody> bodyClass;
    private final QName bodyQName;
    private final Class<? extends AxiomSOAPFault> faultClass;
    private final QName faultQName;
    private final Class<? extends AxiomSOAPFaultCode> faultCodeClass;
    private final Class<? extends AxiomSOAPFaultReason> faultReasonClass;
    private final Class<? extends AxiomSOAPFaultRole> faultRoleClass;
    private final Class<? extends AxiomSOAPFaultDetail> faultDetailClass;
    private final QName mustUnderstandAttributeQName;
    private final QName roleAttributeQName;
    private final QName relayAttributeQName;

    private SOAPHelper(SOAPVersion version, String specName, Class<? extends AxiomSOAPHeader> headerClass, Class<? extends AxiomSOAPHeaderBlock> headerBlockClass, Class<? extends AxiomSOAPBody> bodyClass, Class<? extends AxiomSOAPFault> faultClass, Class<? extends AxiomSOAPFaultCode> faultCodeClass, Class<? extends AxiomSOAPFaultReason> faultReasonClass, Class<? extends AxiomSOAPFaultRole> faultRoleClass, Class<? extends AxiomSOAPFaultDetail> faultDetailClass, String roleAttributeLocalName, String relayAttributeLocalName) {
        this.version = version;
        this.specName = specName;
        this.headerClass = headerClass;
        this.headerQName = new QName(version.getEnvelopeURI(), "Header", "soapenv");
        this.headerBlockClass = headerBlockClass;
        this.bodyClass = bodyClass;
        this.bodyQName = new QName(version.getEnvelopeURI(), "Body", "soapenv");
        this.faultClass = faultClass;
        this.faultQName = new QName(version.getEnvelopeURI(), "Fault", "soapenv");
        this.faultCodeClass = faultCodeClass;
        this.faultReasonClass = faultReasonClass;
        this.faultRoleClass = faultRoleClass;
        this.faultDetailClass = faultDetailClass;
        this.mustUnderstandAttributeQName = new QName(version.getEnvelopeURI(), "mustUnderstand", "soapenv");
        this.roleAttributeQName = new QName(version.getEnvelopeURI(), roleAttributeLocalName, "soapenv");
        this.relayAttributeQName = relayAttributeLocalName == null ? null : new QName(version.getEnvelopeURI(), relayAttributeLocalName, "soapenv");
    }

    final SOAPVersion getVersion() {
        return this.version;
    }

    final String getSpecName() {
        return this.specName;
    }

    final Class<? extends AxiomSOAPHeader> getHeaderClass() {
        return this.headerClass;
    }

    final QName getHeaderQName() {
        return this.headerQName;
    }

    final Class<? extends AxiomSOAPHeaderBlock> getHeaderBlockClass() {
        return this.headerBlockClass;
    }

    final Class<? extends AxiomSOAPBody> getBodyClass() {
        return this.bodyClass;
    }

    final QName getBodyQName() {
        return this.bodyQName;
    }

    final Class<? extends AxiomSOAPFault> getFaultClass() {
        return this.faultClass;
    }

    final QName getFaultQName() {
        return this.faultQName;
    }

    final Class<? extends AxiomSOAPFaultCode> getFaultCodeClass() {
        return this.faultCodeClass;
    }

    final QName getFaultCodeQName() {
        return this.version.getFaultCodeQName();
    }

    final Class<? extends AxiomSOAPFaultReason> getFaultReasonClass() {
        return this.faultReasonClass;
    }

    final QName getFaultReasonQName() {
        return this.version.getFaultReasonQName();
    }

    final Class<? extends AxiomSOAPFaultRole> getFaultRoleClass() {
        return this.faultRoleClass;
    }

    final QName getFaultRoleQName() {
        return this.version.getFaultRoleQName();
    }

    final Class<? extends AxiomSOAPFaultDetail> getFaultDetailClass() {
        return this.faultDetailClass;
    }

    final QName getFaultDetailQName() {
        return this.version.getFaultDetailQName();
    }

    final QName getMustUnderstandAttributeQName() {
        return this.mustUnderstandAttributeQName;
    }

    final QName getRoleAttributeQName() {
        return this.roleAttributeQName;
    }

    final QName getRelayAttributeQName() {
        return this.relayAttributeQName;
    }

    abstract Boolean parseBoolean(String var1);

    abstract String formatBoolean(boolean var1);

    /* synthetic */ SOAPHelper(SOAPVersion sOAPVersion, String string, Class clazz, Class clazz2, Class clazz3, Class clazz4, Class clazz5, Class clazz6, Class clazz7, Class clazz8, String string2, String string3, SOAPHelper sOAPHelper) {
        this(sOAPVersion, string, clazz, clazz2, clazz3, clazz4, clazz5, clazz6, clazz7, clazz8, string2, string3);
    }
}

