/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.core.DeferringParentNodeSupport;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.QNameAwareOMDataSource;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.common.AxiomContainer;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.common.OMDataSourceUtil;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.llom.DeferredNamespace;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.PushOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSourcedElementImpl
extends OMElementImpl
implements OMSourcedElement {
    private OMDataSource dataSource;
    private OMNamespace definedNamespace;
    private boolean definedNamespaceSet;
    private boolean isExpanded = true;
    private static final Log log = LogFactory.getLog(OMSourcedElementImpl.class);
    private static final Log forceExpandLog = LogFactory.getLog((String)(String.valueOf(OMSourcedElementImpl.class.getName()) + ".forceExpand"));

    private static OMNamespace getOMNamespace(QName qName) {
        return qName.getNamespaceURI().length() == 0 ? null : new OMNamespaceImpl(qName.getNamespaceURI(), qName.getPrefix());
    }

    public OMSourcedElementImpl(OMFactory factory, OMDataSource source) {
        super(factory);
        this.dataSource = source;
        this.isExpanded = false;
    }

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory, OMDataSource source) {
        super(factory);
        if (source == null) {
            throw new IllegalArgumentException("OMDataSource can't be null");
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, localName);
        this.dataSource = source;
        this.isExpanded = false;
        if (ns != null && ns.getNamespaceURI().length() == 0) {
            ns = null;
        }
        if (ns == null || !OMSourcedElementImpl.isLossyPrefix(this.dataSource) && ns.getPrefix() != null) {
            this.definedNamespace = ns;
        } else {
            String uri = ns.getNamespaceURI();
            this.definedNamespace = new DeferredNamespace(this, uri);
        }
        this.definedNamespaceSet = true;
    }

    public OMSourcedElementImpl(QName qName, OMFactory factory, OMDataSource source) {
        super(factory);
        String uri;
        if (source == null) {
            throw new IllegalArgumentException("OMDataSource can't be null");
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, qName.getLocalPart());
        this.dataSource = source;
        this.isExpanded = false;
        this.definedNamespace = !OMSourcedElementImpl.isLossyPrefix(this.dataSource) ? OMSourcedElementImpl.getOMNamespace(qName) : ((uri = qName.getNamespaceURI()).length() == 0 ? null : new DeferredNamespace(this, uri));
        this.definedNamespaceSet = true;
    }

    public OMSourcedElementImpl(OMFactory factory) {
        super(factory);
    }

    private static boolean isLossyPrefix(OMDataSource source) {
        Object lossyPrefix = null;
        if (source instanceof OMDataSourceExt) {
            lossyPrefix = ((OMDataSourceExt)source).getProperty("lossyPrefix");
        }
        return lossyPrefix == Boolean.TRUE;
    }

    private String getPrintableName() {
        if (this.isExpanded || this.definedNamespaceSet && AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this) != null) {
            String uri = null;
            if (this.getNamespace() != null) {
                uri = this.getNamespace().getNamespaceURI();
            }
            if (uri == null || uri.length() == 0) {
                return this.getLocalName();
            }
            return "{" + uri + '}' + this.getLocalName();
        }
        return "<unknown>";
    }

    public void forceExpand() {
        if (!this.isExpanded && this.dataSource != null) {
            XMLStreamReader readerFromDS;
            if (log.isDebugEnabled()) {
                log.debug((Object)("forceExpand: expanding element " + this.getPrintableName()));
                if (forceExpandLog.isDebugEnabled()) {
                    Exception e = new Exception("Debug Stack Trace");
                    forceExpandLog.debug((Object)"forceExpand stack", (Throwable)e);
                }
            }
            if (OMDataSourceUtil.isPushDataSource(this.dataSource)) {
                this.isExpanded = true;
                try {
                    this.dataSource.serialize((XMLStreamWriter)((Object)new PushOMBuilder(this)));
                }
                catch (XMLStreamException ex) {
                    throw new OMException("Failed to expand data source", (Throwable)ex);
                }
            }
            try {
                readerFromDS = this.dataSource.getReader();
            }
            catch (XMLStreamException ex) {
                throw new OMException("Error obtaining parser from data source for element " + this.getPrintableName(), (Throwable)ex);
            }
            String characterEncoding = readerFromDS.getCharacterEncodingScheme();
            if (characterEncoding != null) {
                characterEncoding = readerFromDS.getEncoding();
            }
            try {
                if (readerFromDS.getEventType() != 1) {
                    while (readerFromDS.next() != 1) {
                    }
                }
            }
            catch (XMLStreamException ex) {
                throw new OMException("Error parsing data source document for element " + this.getLocalName(), (Throwable)ex);
            }
            this.validateName(readerFromDS.getPrefix(), readerFromDS.getLocalName(), readerFromDS.getNamespaceURI());
            this.isExpanded = true;
            StAXOMBuilder builder = new StAXOMBuilder(this.getOMFactory(), readerFromDS, (OMElement)this, characterEncoding);
            builder.setAutoClose(true);
            DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, (OMXMLParserWrapper)builder);
            this.setComplete(false);
        }
    }

    void validateName(String staxPrefix, String staxLocalName, String staxNamespaceURI) {
        if (AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this) == null) {
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, staxLocalName);
        } else if (!staxLocalName.equals(AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this))) {
            throw new OMException("Element name from data source is " + staxLocalName + ", not the expected " + AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this));
        }
        if (this.definedNamespaceSet) {
            String namespaceURI;
            if (staxNamespaceURI == null) {
                staxNamespaceURI = "";
            }
            String string = namespaceURI = this.definedNamespace == null ? "" : this.definedNamespace.getNamespaceURI();
            if (!staxNamespaceURI.equals(namespaceURI)) {
                throw new OMException("Element namespace from data source is " + staxNamespaceURI + ", not the expected " + namespaceURI);
            }
            if (!(this.definedNamespace instanceof DeferredNamespace)) {
                String prefix;
                if (staxPrefix == null) {
                    staxPrefix = "";
                }
                String string2 = prefix = this.definedNamespace == null ? "" : this.definedNamespace.getPrefix();
                if (!staxPrefix.equals(prefix)) {
                    throw new OMException("Element prefix from data source is '" + staxPrefix + "', not the expected '" + prefix + "'");
                }
            }
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader for " + this.getPrintableName() + " with cache=" + cache));
        }
        if (this.isExpanded) {
            return AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$defaultGetXMLStreamReader(this, cache, configuration);
        }
        if (cache && OMDataSourceUtil.isDestructiveRead(this.dataSource) || OMDataSourceUtil.isPushDataSource(this.dataSource)) {
            this.forceExpand();
            return AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$defaultGetXMLStreamReader(this, true, configuration);
        }
        try {
            return this.dataSource.getReader();
        }
        catch (XMLStreamException ex) {
            throw new OMException("Error obtaining parser from data source for element " + this.getPrintableName(), (Throwable)ex);
        }
    }

    public final void updateLocalName() {
        if (this.dataSource instanceof QNameAwareOMDataSource) {
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(this, ((QNameAwareOMDataSource)this.dataSource).getLocalName());
        }
        if (AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this) == null) {
            this.forceExpand();
        }
    }

    public OMNamespace getNamespace() throws OMException {
        String namespaceURI;
        if (this.isExpanded()) {
            return AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$defaultGetNamespace(this);
        }
        if (this.definedNamespaceSet) {
            return this.definedNamespace;
        }
        if (this.dataSource instanceof QNameAwareOMDataSource && (namespaceURI = ((QNameAwareOMDataSource)this.dataSource).getNamespaceURI()) != null) {
            if (namespaceURI.length() == 0) {
                this.definedNamespaceSet = true;
            } else {
                String prefix = ((QNameAwareOMDataSource)this.dataSource).getPrefix();
                this.definedNamespace = prefix == null ? new DeferredNamespace(this, namespaceURI) : new OMNamespaceImpl(namespaceURI, prefix);
                this.definedNamespaceSet = true;
            }
        }
        if (this.definedNamespaceSet) {
            return this.definedNamespace;
        }
        this.forceExpand();
        return AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$defaultGetNamespace(this);
    }

    public QName getQName() {
        if (this.isExpanded()) {
            return AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$defaultGetQName(this);
        }
        if (this.getNamespace() != null) {
            return new QName(this.getNamespace().getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    OMNode clone(OMCloneOptions options, AxiomContainer targetParent) {
        OMDataSource ds = this.getDataSource();
        if (!options.isCopyOMDataSources() || ds == null || this.isExpanded() || !(ds instanceof OMDataSourceExt)) {
            return this.defaultClone(options, targetParent);
        }
        OMDataSourceExt sourceDS = (OMDataSourceExt)ds;
        if (sourceDS.isDestructiveRead() || sourceDS.isDestructiveWrite()) {
            return this.defaultClone(options, targetParent);
        }
        OMDataSourceExt targetDS = ((OMDataSourceExt)ds).copy();
        if (targetDS == null) {
            return this.defaultClone(options, targetParent);
        }
        OMSourcedElementImpl targetOMSE = options.isPreserveModel() ? (OMSourcedElementImpl)this.createClone(options, (OMDataSource)targetDS) : (OMSourcedElementImpl)this.getOMFactory().createOMElement((OMDataSource)targetDS);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalSetLocalName(targetOMSE, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$internalGetLocalName(this));
        targetOMSE.definedNamespaceSet = this.definedNamespaceSet;
        targetOMSE.definedNamespace = this.definedNamespace instanceof DeferredNamespace ? new DeferredNamespace(targetOMSE, this.definedNamespace.getNamespaceURI()) : this.definedNamespace;
        if (targetParent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild(targetParent, (OMNode)targetOMSE);
        }
        return targetOMSE;
    }

    protected OMSourcedElement createClone(OMCloneOptions options, OMDataSource ds) {
        return this.getOMFactory().createOMElement(ds);
    }

    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        if (this.isExpanded()) {
            AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$defaultInternalSerialize(this, serializer, format, cache);
        } else if (cache) {
            if (OMDataSourceUtil.isDestructiveWrite(this.dataSource)) {
                this.forceExpand();
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$defaultInternalSerialize(this, serializer, format, true);
            } else {
                serializer.serialize(this.dataSource);
            }
        } else {
            serializer.serialize(this.dataSource);
        }
    }

    public void buildWithAttachments() {
        if (CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$getState(this) == 1) {
            this.build();
        }
        if (this.isExpanded()) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                node.buildWithAttachments();
            }
        }
    }

    public OMDataSource getDataSource() {
        return this.dataSource;
    }

    public OMDataSource setDataSource(OMDataSource dataSource) {
        if (!this.isExpanded()) {
            OMDataSource oldDS = this.dataSource;
            this.dataSource = dataSource;
            return oldDS;
        }
        OMDataSource oldDS = this.dataSource;
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.dataSource = dataSource;
        this.setComplete(false);
        this.isExpanded = false;
        DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$coreSetBuilder(this, null);
        if (OMSourcedElementImpl.isLossyPrefix(dataSource)) {
            this.definedNamespace = new DeferredNamespace(this, this.definedNamespace.getNamespaceURI());
        }
        return oldDS;
    }

    public void setComplete(boolean complete) {
        CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreSetState(this, complete ? 0 : 1);
        if (complete && this.dataSource != null) {
            if (this.dataSource instanceof OMDataSourceExt) {
                ((OMDataSourceExt)this.dataSource).close();
            }
            this.dataSource = null;
        }
    }

    public Object getObject(Class dataSourceClass) {
        if (this.dataSource == null || this.isExpanded || !dataSourceClass.isInstance(this.dataSource)) {
            return null;
        }
        return ((OMDataSourceExt)this.dataSource).getObject();
    }
}

