/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextTokenProcessor
implements Processor {
    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        SecurityContextToken sct = new SecurityContextToken(elem);
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        WSSecurityEngineResult result = new WSSecurityEngineResult(1024, sct);
        if (validator != null) {
            Credential credential = new Credential();
            credential.setSecurityContextToken(sct);
            Credential returnedCredential = validator.validate(credential, data);
            result.put("validated-token", Boolean.TRUE);
            String tokenId = sct.getID();
            if (!"".equals(tokenId)) {
                result.put("id", tokenId);
            }
            result.put("secret", returnedCredential.getSecretKey());
        } else {
            String id = sct.getID();
            if (id.charAt(0) == '#') {
                id = id.substring(1);
            }
            byte[] secret = null;
            try {
                secret = this.getSecret(data.getCallbackHandler(), sct.getIdentifier());
            }
            catch (WSSecurityException ex) {
                secret = this.getSecret(data.getCallbackHandler(), id);
            }
            if (secret == null || secret.length == 0) {
                secret = this.getSecret(data.getCallbackHandler(), id);
            }
            result.put("id", sct.getID());
            result.put("secret", secret);
        }
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    private byte[] getSecret(CallbackHandler cb, String identifier) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback callback = new WSPasswordCallback(identifier, 6);
        try {
            Callback[] callbacks = new Callback[]{callback};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{identifier}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{identifier}, e);
        }
        return callback.getKey();
    }
}

