/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;

public abstract class AbstractOutlineFont
extends AFPFont {
    protected CharacterSet charSet;
    private final AFPEventProducer eventProducer;

    public AbstractOutlineFont(String name, boolean embeddable, CharacterSet charSet, AFPEventProducer eventProducer) {
        super(name, embeddable);
        this.charSet = charSet;
        this.eventProducer = eventProducer;
    }

    AFPEventProducer getAFPEventProducer() {
        return this.eventProducer;
    }

    public CharacterSet getCharacterSet() {
        return this.charSet;
    }

    @Override
    public CharacterSet getCharacterSet(int size) {
        return this.charSet;
    }

    @Override
    public int getAscender(int size) {
        return this.charSet.getAscender() * size;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return this.charSet.getUnderscorePosition() * size;
    }

    @Override
    public int getUnderlineThickness(int size) {
        int underscoreWidth = this.charSet.getUnderscoreWidth();
        return underscoreWidth == 0 ? super.getUnderlineThickness(size) : underscoreWidth * size;
    }

    @Override
    public int getCapHeight(int size) {
        return this.charSet.getCapHeight() * size;
    }

    @Override
    public int getDescender(int size) {
        return this.charSet.getDescender() * size;
    }

    @Override
    public int getXHeight(int size) {
        return this.charSet.getXHeight() * size;
    }

    @Override
    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    @Override
    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    @Override
    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

