/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;

public class ConditionalBorder {
    public static final int NORMAL = 0;
    public static final int LEADING_TRAILING = 1;
    public static final int REST = 2;
    BorderSpecification leadingTrailing;
    BorderSpecification nonLeadingTrailing;
    BorderSpecification rest;
    private CollapsingBorderModel collapsingBorderModel;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ConditionalBorder(BorderSpecification leadingTrailing, BorderSpecification nonLeadingTrailing, BorderSpecification rest, CollapsingBorderModel collapsingBorderModel) {
        this.leadingTrailing = leadingTrailing;
        this.nonLeadingTrailing = nonLeadingTrailing;
        this.rest = rest;
        this.collapsingBorderModel = collapsingBorderModel;
    }

    ConditionalBorder(BorderSpecification borderSpecification, CollapsingBorderModel collapsingBorderModel) {
        this.nonLeadingTrailing = this.leadingTrailing = borderSpecification;
        this.rest = borderSpecification.getBorderInfo().getWidth().isDiscard() ? BorderSpecification.getDefaultBorder() : this.leadingTrailing;
        this.collapsingBorderModel = collapsingBorderModel;
    }

    void resolve(ConditionalBorder competitor, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
        BorderSpecification resolvedBorder;
        if (withLeadingTrailing && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.leadingTrailing, competitor.leadingTrailing)) != null) {
            this.leadingTrailing = resolvedBorder;
            competitor.leadingTrailing = resolvedBorder;
        }
        if (withNonLeadingTrailing && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.nonLeadingTrailing, competitor.nonLeadingTrailing)) != null) {
            this.nonLeadingTrailing = resolvedBorder;
            competitor.nonLeadingTrailing = resolvedBorder;
        }
        if (withRest && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.rest, competitor.rest)) != null) {
            this.rest = resolvedBorder;
            competitor.rest = resolvedBorder;
        }
    }

    void integrateCompetingSegment(ConditionalBorder competitor, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
        BorderSpecification resolvedBorder;
        if (withLeadingTrailing && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.leadingTrailing, competitor.leadingTrailing)) != null) {
            this.leadingTrailing = resolvedBorder;
        }
        if (withNonLeadingTrailing && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.nonLeadingTrailing, competitor.nonLeadingTrailing)) != null) {
            this.nonLeadingTrailing = resolvedBorder;
        }
        if (withRest && (resolvedBorder = this.collapsingBorderModel.determineWinner(this.rest, competitor.rest)) != null) {
            this.rest = resolvedBorder;
        }
    }

    void integrateSegment(ConditionalBorder segment, boolean withLeadingTrailing, boolean withNonLeadingTrailing, boolean withRest) {
        if (withLeadingTrailing) {
            this.leadingTrailing = this.collapsingBorderModel.determineWinner(this.leadingTrailing, segment.leadingTrailing);
            if (!$assertionsDisabled && this.leadingTrailing == null) {
                throw new AssertionError();
            }
        }
        if (withNonLeadingTrailing) {
            this.nonLeadingTrailing = this.collapsingBorderModel.determineWinner(this.nonLeadingTrailing, segment.nonLeadingTrailing);
            if (!$assertionsDisabled && this.nonLeadingTrailing == null) {
                throw new AssertionError();
            }
        }
        if (withRest) {
            this.rest = this.collapsingBorderModel.determineWinner(this.rest, segment.rest);
            if (!$assertionsDisabled && this.rest == null) {
                throw new AssertionError();
            }
        }
    }

    ConditionalBorder copy() {
        return new ConditionalBorder(this.leadingTrailing, this.nonLeadingTrailing, this.rest, this.collapsingBorderModel);
    }

    public String toString() {
        return "{non-leading: " + this.nonLeadingTrailing + ", leading: " + this.leadingTrailing + ", rest: " + this.rest + "}";
    }

    static ConditionalBorder getDefaultBorder(CollapsingBorderModel collapsingBorderModel) {
        BorderSpecification defaultBorderSpec = BorderSpecification.getDefaultBorder();
        return new ConditionalBorder(defaultBorderSpec, defaultBorderSpec, defaultBorderSpec, collapsingBorderModel);
    }

    static {
        $assertionsDisabled = !ConditionalBorder.class.desiredAssertionStatus();
    }
}

