/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextElementBridge;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;

public class PDFBridgeContext
extends BridgeContext {
    private final FontInfo fontInfo;
    private final ImageManager imageManager;
    private final ImageSessionContext imageSessionContext;
    private AffineTransform linkTransform;

    public PDFBridgeContext(UserAgent userAgent, DocumentLoader loader, FontInfo fontInfo, ImageManager imageManager, ImageSessionContext imageSessionContext, AffineTransform linkTransform) {
        super(userAgent, loader);
        this.fontInfo = fontInfo;
        this.imageManager = imageManager;
        this.imageSessionContext = imageSessionContext;
        this.linkTransform = linkTransform;
    }

    public PDFBridgeContext(UserAgent userAgent, FontInfo fontInfo, ImageManager imageManager, ImageSessionContext imageSessionContext, AffineTransform linkTransform) {
        super(userAgent);
        this.fontInfo = fontInfo;
        this.imageManager = imageManager;
        this.imageSessionContext = imageSessionContext;
        this.linkTransform = linkTransform;
    }

    public PDFBridgeContext(UserAgent userAgent, FontInfo fontInfo, ImageManager imageManager, ImageSessionContext imageSessionContext) {
        this(userAgent, fontInfo, imageManager, imageSessionContext, null);
    }

    public ImageManager getImageManager() {
        return this.imageManager;
    }

    public ImageSessionContext getImageSessionContext() {
        return this.imageSessionContext;
    }

    private void putPDFElementBridgeConditional(String className, String testFor) {
        try {
            Class.forName(testFor);
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(FontInfo.class);
            this.putBridge((Bridge)constructor.newInstance(this.fontInfo));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerSVGBridges() {
        super.registerSVGBridges();
        if (this.fontInfo != null) {
            PDFTextElementBridge textElementBridge = new PDFTextElementBridge(this.fontInfo);
            this.putBridge((Bridge)textElementBridge);
            this.putPDFElementBridgeConditional("org.apache.fop.svg.PDFBatikFlowTextElementBridge", "org.apache.batik.extension.svg.BatikFlowTextElementBridge");
            this.putPDFElementBridgeConditional("org.apache.fop.svg.PDFSVG12TextElementBridge", "org.apache.batik.bridge.svg12.SVG12TextElementBridge");
            this.putPDFElementBridgeConditional("org.apache.fop.svg.PDFSVGFlowRootElementBridge", "org.apache.batik.bridge.svg12.SVGFlowRootElementBridge");
        }
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        if (this.linkTransform != null) {
            pdfAElementBridge.setCurrentTransform(this.linkTransform);
        } else {
            pdfAElementBridge.setCurrentTransform(new AffineTransform());
        }
        this.putBridge((Bridge)pdfAElementBridge);
        this.putBridge((Bridge)new PDFImageElementBridge());
    }

    public BridgeContext createBridgeContext() {
        return new PDFBridgeContext(this.getUserAgent(), this.getDocumentLoader(), this.fontInfo, this.getImageManager(), this.getImageSessionContext(), this.linkTransform);
    }
}

