/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.fonts.AFPFontCollection;
import org.apache.fop.afp.fonts.AFPFontInfo;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FopCharacterSet;
import org.apache.fop.afp.fonts.OutlineFont;
import org.apache.fop.afp.fonts.RasterFont;
import org.apache.fop.afp.util.DefaultFOPResourceAccessor;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.afp.AFPCustomizable;
import org.apache.fop.render.afp.AFPDocumentHandler;
import org.apache.fop.render.afp.AFPRenderer;
import org.apache.fop.render.afp.AFPShadingMode;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.util.LogUtil;

public class AFPRendererConfigurator
extends PrintRendererConfigurator
implements IFDocumentHandlerConfigurator {
    private static final String IMAGES_MODE_GRAYSCALE = "b+w";
    private static final String IMAGES_MODE_COLOR = "color";

    public AFPRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    private AFPFontInfo buildFont(Configuration fontCfg, String fontPath) throws ConfigurationException {
        Configuration[] triple = fontCfg.getChildren("font-triplet");
        ArrayList<FontTriplet> tripletList = new ArrayList<FontTriplet>();
        if (triple.length == 0) {
            log.error((Object)"Mandatory font configuration element '<font-triplet...' is missing");
            return null;
        }
        for (int j = 0; j < triple.length; ++j) {
            int weight = FontUtil.parseCSS2FontWeight(triple[j].getAttribute("weight"));
            FontTriplet triplet = new FontTriplet(triple[j].getAttribute("name"), triple[j].getAttribute("style"), weight);
            tripletList.add(triplet);
        }
        Configuration afpFontCfg = fontCfg.getChild("afp-font");
        if (afpFontCfg == null) {
            log.error((Object)"Mandatory font configuration element '<afp-font...' is missing");
            return null;
        }
        URI baseURI = null;
        String uri = afpFontCfg.getAttribute("base-uri", fontPath);
        if (uri == null) {
            String path = afpFontCfg.getAttribute("path", fontPath);
            if (path != null) {
                File f = new File(path);
                baseURI = f.toURI();
            }
        } else {
            try {
                baseURI = new URI(uri);
            }
            catch (URISyntaxException e) {
                log.error((Object)("Invalid URI: " + e.getMessage()));
                return null;
            }
        }
        DefaultFOPResourceAccessor accessor = new DefaultFOPResourceAccessor(this.userAgent, this.userAgent.getFactory().getFontManager().getFontBaseURL(), baseURI);
        String type = afpFontCfg.getAttribute("type");
        if (type == null) {
            log.error((Object)"Mandatory afp-font configuration attribute 'type=' is missing");
            return null;
        }
        String codepage = afpFontCfg.getAttribute("codepage");
        if (codepage == null) {
            log.error((Object)"Mandatory afp-font configuration attribute 'code=' is missing");
            return null;
        }
        String encoding = afpFontCfg.getAttribute("encoding");
        if (encoding == null) {
            log.error((Object)"Mandatory afp-font configuration attribute 'encoding=' is missing");
            return null;
        }
        if ("raster".equalsIgnoreCase(type)) {
            String name = afpFontCfg.getAttribute("name", "Unknown");
            RasterFont font = new RasterFont(name);
            Configuration[] rasters = afpFontCfg.getChildren("afp-raster-font");
            if (rasters.length == 0) {
                log.error((Object)"Mandatory font configuration elements '<afp-raster-font...' are missing");
                return null;
            }
            for (int j = 0; j < rasters.length; ++j) {
                Configuration rasterCfg = rasters[j];
                String characterset = rasterCfg.getAttribute("characterset");
                if (characterset == null) {
                    log.error((Object)"Mandatory afp-raster-font configuration attribute 'characterset=' is missing");
                    return null;
                }
                int size = rasterCfg.getAttributeAsInteger("size");
                String base14 = rasterCfg.getAttribute("base14-font", null);
                if (base14 != null) {
                    try {
                        Class<?> clazz = Class.forName("org.apache.fop.fonts.base14." + base14);
                        try {
                            Typeface tf = (Typeface)clazz.newInstance();
                            font.addCharacterSet(size, new FopCharacterSet(codepage, encoding, characterset, tf));
                        }
                        catch (Exception ie) {
                            String msg = "The base 14 font class " + clazz.getName() + " could not be instantiated";
                            log.error((Object)msg);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        String msg = "The base 14 font class for " + characterset + " could not be found";
                        log.error((Object)msg);
                    }
                    continue;
                }
                font.addCharacterSet(size, new CharacterSet(codepage, encoding, characterset, accessor));
            }
            return new AFPFontInfo(font, tripletList);
        }
        if ("outline".equalsIgnoreCase(type)) {
            String characterset = afpFontCfg.getAttribute("characterset");
            if (characterset == null) {
                log.error((Object)"Mandatory afp-font configuration attribute 'characterset=' is missing");
                return null;
            }
            String name = afpFontCfg.getAttribute("name", characterset);
            CharacterSet characterSet = null;
            String base14 = afpFontCfg.getAttribute("base14-font", null);
            if (base14 != null) {
                try {
                    Class<?> clazz = Class.forName("org.apache.fop.fonts.base14." + base14);
                    try {
                        Typeface tf = (Typeface)clazz.newInstance();
                        characterSet = new FopCharacterSet(codepage, encoding, characterset, tf);
                    }
                    catch (Exception ie) {
                        String msg = "The base 14 font class " + clazz.getName() + " could not be instantiated";
                        log.error((Object)msg);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    String msg = "The base 14 font class for " + characterset + " could not be found";
                    log.error((Object)msg);
                }
            } else {
                characterSet = new CharacterSet(codepage, encoding, characterset, accessor);
            }
            OutlineFont font = new OutlineFont(name, characterSet);
            return new AFPFontInfo(font, tripletList);
        }
        log.error((Object)"No or incorrect type attribute");
        return null;
    }

    private List buildFontListFromConfiguration(Configuration cfg) throws ConfigurationException {
        ArrayList<AFPFontInfo> fontList = new ArrayList<AFPFontInfo>();
        Configuration[] font = cfg.getChild("fonts").getChildren("font");
        String fontPath = null;
        for (int i = 0; i < font.length; ++i) {
            AFPFontInfo afi = this.buildFont(font[i], fontPath);
            if (afi == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding font " + afi.getAFPFont().getFontName()));
                List fontTriplets = afi.getFontTriplets();
                for (int j = 0; j < fontTriplets.size(); ++j) {
                    FontTriplet triplet = (FontTriplet)fontTriplets.get(j);
                    log.debug((Object)("  Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight()));
                }
            }
            fontList.add(afi);
        }
        return fontList;
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            AFPRenderer afpRenderer = (AFPRenderer)renderer;
            try {
                List fontList = this.buildFontListFromConfiguration(cfg);
                afpRenderer.setFontList(fontList);
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, (Exception)((Object)e), this.userAgent.getFactory().validateUserConfigStrictly());
            }
            this.configure(afpRenderer, cfg);
        }
    }

    private void configure(AFPCustomizable customizable, Configuration cfg) throws FOPException {
        Configuration defaultResourceLevelCfg;
        Configuration resourceGroupFileCfg;
        Configuration imagesCfg = cfg.getChild("images");
        String imagesMode = imagesCfg.getAttribute("mode", IMAGES_MODE_GRAYSCALE);
        if (IMAGES_MODE_COLOR.equals(imagesMode)) {
            customizable.setColorImages(true);
        } else {
            customizable.setColorImages(false);
            int bitsPerPixel = imagesCfg.getAttributeAsInteger("bits-per-pixel", 8);
            customizable.setBitsPerPixel(bitsPerPixel);
        }
        boolean nativeImageSupport = imagesCfg.getAttributeAsBoolean("native", false);
        customizable.setNativeImagesSupported(nativeImageSupport);
        Configuration shadingCfg = cfg.getChild("shading");
        AFPShadingMode shadingMode = AFPShadingMode.valueOf(shadingCfg.getValue(AFPShadingMode.COLOR.getName()));
        customizable.setShadingMode(shadingMode);
        Configuration rendererResolutionCfg = cfg.getChild("renderer-resolution", false);
        if (rendererResolutionCfg != null) {
            customizable.setResolution(rendererResolutionCfg.getValueAsInteger(240));
        }
        if ((resourceGroupFileCfg = cfg.getChild("resource-group-file", false)) != null) {
            String resourceGroupDest = null;
            try {
                resourceGroupDest = resourceGroupFileCfg.getValue();
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, (Exception)((Object)e), this.userAgent.getFactory().validateUserConfigStrictly());
            }
            File resourceGroupFile = new File(resourceGroupDest);
            if (resourceGroupFile.canWrite()) {
                customizable.setDefaultResourceGroupFilePath(resourceGroupDest);
            } else {
                log.warn((Object)("Unable to write to default external resource group file '" + resourceGroupDest + "'"));
            }
        }
        if ((defaultResourceLevelCfg = cfg.getChild("default-resource-levels", false)) != null) {
            AFPResourceLevelDefaults defaults = new AFPResourceLevelDefaults();
            String[] types = defaultResourceLevelCfg.getAttributeNames();
            int c = types.length;
            for (int i = 0; i < c; ++i) {
                String type = types[i];
                try {
                    String level = defaultResourceLevelCfg.getAttribute(type);
                    defaults.setDefaultResourceLevel(type, AFPResourceLevel.valueOf(level));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    LogUtil.handleException(log, iae, this.userAgent.getFactory().validateUserConfigStrictly());
                    continue;
                }
                catch (ConfigurationException e) {
                    LogUtil.handleException(log, (Exception)((Object)e), this.userAgent.getFactory().validateUserConfigStrictly());
                }
            }
            customizable.setResourceLevelDefaults(defaults);
        }
    }

    public void configure(IFDocumentHandler documentHandler) throws FOPException {
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            AFPDocumentHandler afpDocumentHandler = (AFPDocumentHandler)documentHandler;
            this.configure(afpDocumentHandler, cfg);
        }
    }

    public void setupFontInfo(IFDocumentHandler documentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        ArrayList<AFPFontCollection> fontCollections = new ArrayList<AFPFontCollection>();
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            try {
                List fontList = this.buildFontListFromConfiguration(cfg);
                fontCollections.add(new AFPFontCollection(this.userAgent.getEventBroadcaster(), fontList));
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, (Exception)((Object)e), this.userAgent.getFactory().validateUserConfigStrictly());
            }
        } else {
            fontCollections.add(new AFPFontCollection(this.userAgent.getEventBroadcaster(), null));
        }
        fontManager.setup(fontInfo, fontCollections.toArray(new FontCollection[fontCollections.size()]));
        documentHandler.setFontInfo(fontInfo);
    }
}

