/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;

public class AFPResourceLevelDefaults {
    private static final Map RESOURCE_TYPE_NAMES = new HashMap();
    private Map defaultResourceLevels = new HashMap();

    private static void registerResourceTypeName(String name, byte type) {
        RESOURCE_TYPE_NAMES.put(name.toLowerCase(), new Byte(type));
    }

    private static byte getResourceType(String resourceTypeName) {
        Byte result = (Byte)RESOURCE_TYPE_NAMES.get(resourceTypeName.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("Unknown resource type name: " + resourceTypeName);
        }
        return result;
    }

    public AFPResourceLevelDefaults() {
        this.setDefaultResourceLevel((byte)3, new AFPResourceLevel(0));
    }

    public void setDefaultResourceLevel(String type, AFPResourceLevel level) {
        this.setDefaultResourceLevel(AFPResourceLevelDefaults.getResourceType(type), level);
    }

    public void setDefaultResourceLevel(byte type, AFPResourceLevel level) {
        this.defaultResourceLevels.put(new Byte(type), level);
    }

    public AFPResourceLevel getDefaultResourceLevel(byte type) {
        AFPResourceLevel result = (AFPResourceLevel)this.defaultResourceLevels.get(new Byte(type));
        if (result == null) {
            result = AFPResourceInfo.DEFAULT_LEVEL;
        }
        return result;
    }

    public void mergeFrom(AFPResourceLevelDefaults other) {
        for (Map.Entry entry : other.defaultResourceLevels.entrySet()) {
            Byte type = (Byte)entry.getKey();
            AFPResourceLevel level = (AFPResourceLevel)entry.getValue();
            this.defaultResourceLevels.put(type, level);
        }
    }

    static {
        AFPResourceLevelDefaults.registerResourceTypeName("goca", (byte)3);
        AFPResourceLevelDefaults.registerResourceTypeName("bitmap", (byte)6);
    }
}

