/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.io.File;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.configuration.model.core.cache.ExpiringSimpleCacheProperties;
import org.apereo.cas.configuration.model.core.cache.SimpleCacheProperties;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;
import org.springframework.util.StringUtils;

public final class Beans {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Beans.class);

    public static FactoryBean<ExecutorService> newThreadPoolExecutorFactoryBean(ConnectionPoolingProperties config) {
        ThreadPoolExecutorFactoryBean bean = new ThreadPoolExecutorFactoryBean();
        bean.setMaxPoolSize(config.getMaxSize());
        bean.setCorePoolSize(config.getMinSize());
        bean.afterPropertiesSet();
        return bean;
    }

    public static Duration newDuration(String value) {
        if (Beans.isNeverDurable(value)) {
            return Duration.ZERO;
        }
        if (Beans.isInfinitelyDurable(value)) {
            return Duration.ofDays(Integer.MAX_VALUE);
        }
        if (NumberUtils.isCreatable((String)value)) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        return Duration.parse(value);
    }

    public static boolean isInfinitelyDurable(String value) {
        return "-1".equalsIgnoreCase(value) || !StringUtils.hasText((String)value) || "INFINITE".equalsIgnoreCase(value);
    }

    public static boolean isNeverDurable(String value) {
        return "0".equalsIgnoreCase(value) || "NEVER".equalsIgnoreCase(value) || !StringUtils.hasText((String)value);
    }

    public static String getTempFilePath(String prefix, String suffix) {
        return (String)Unchecked.supplier(() -> File.createTempFile(prefix, suffix).getCanonicalPath()).get();
    }

    public static <T, V> Cache<T, V> newCache(SimpleCacheProperties cache, Expiry<T, V> expiryAfter) {
        return Beans.newCacheBuilder(cache).expireAfter(expiryAfter).build();
    }

    public static Caffeine newCacheBuilder(SimpleCacheProperties cache) {
        Caffeine builder = Caffeine.newBuilder().initialCapacity(cache.getInitialCapacity()).maximumSize(cache.getCacheSize());
        if (cache instanceof ExpiringSimpleCacheProperties) {
            ExpiringSimpleCacheProperties expiring = (ExpiringSimpleCacheProperties)cache;
            builder.expireAfterWrite(Beans.newDuration(expiring.getDuration()));
        }
        builder.removalListener((key, value, cause) -> {
            LOGGER.trace("Removing cached value [{}] linked to cache key [{}]; removal cause is [{}]", new Object[]{value, key, cause});
            Unchecked.consumer(__ -> {
                if (value instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)value;
                    Objects.requireNonNull(closeable).close();
                }
            }).accept(value);
        });
        return builder;
    }

    @Generated
    private Beans() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

