/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.util.DigestUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class ServiceAccessEnforcementAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        Objects.requireNonNull(returnValue, "AuditableExecutionResult must not be null");
        AuditableExecutionResult serviceAccessCheckResult = (AuditableExecutionResult)AuditableExecutionResult.class.cast(returnValue);
        String accessCheckOutcome = "Service Access " + BooleanUtils.toString((boolean)serviceAccessCheckResult.isExecutionFailure(), (String)"Denied", (String)"Granted");
        HashMap<String, CallSite> values = new HashMap<String, CallSite>();
        values.put("result", (CallSite)((Object)accessCheckOutcome));
        serviceAccessCheckResult.getService().ifPresent(service -> values.put("service", (CallSite)((Object)DigestUtils.abbreviate((String)service.getId()))));
        serviceAccessCheckResult.getAuthentication().ifPresent(authn -> values.put("principal", (CallSite)authn.getPrincipal()));
        serviceAccessCheckResult.getRegisteredService().ifPresent(regSvc -> values.put("requiredAttributes", (CallSite)((Object)regSvc.getAccessStrategy().getRequiredAttributes())));
        return new String[]{this.auditFormat.serialize(values)};
    }
}

