/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.principal;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableEntity;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.logout.slo.SingleLogoutExecutionRequest;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;

public class DefaultAuditPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuditPrincipalResolver.class);
    private final AuditPrincipalIdProvider auditPrincipalIdProvider;

    public String resolveFrom(JoinPoint auditTarget, Object returnValue) {
        LOGGER.trace("Resolving principal at audit point [{}]", (Object)auditTarget);
        return this.getCurrentPrincipal(auditTarget, returnValue, null);
    }

    public String resolveFrom(JoinPoint auditTarget, Exception exception) {
        LOGGER.trace("Resolving principal at audit point [{}] with exception [{}]", (Object)auditTarget, (Object)exception.getMessage());
        return this.getCurrentPrincipal(auditTarget, null, exception);
    }

    public String resolve() {
        return "audit:unknown";
    }

    protected String getCurrentPrincipal(JoinPoint auditTarget, Object returnValue, Exception exception) {
        String currentPrincipal = "audit:unknown";
        if (auditTarget.getArgs() != null && auditTarget.getArgs().length > 0) {
            Object firstArgument;
            Object object = firstArgument = auditTarget.getArgs()[0];
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RequestContext.class, AuthenticationTransaction.class, SingleLogoutExecutionRequest.class, Authentication.class, AuthenticationResult.class, AuditableContext.class, AuditableEntity.class, Assertion.class, Credential.class}, (Object)object2, n)) {
                case 0: {
                    RequestContext requestContext = (RequestContext)object2;
                    String string = this.getPrincipalFromRequestContext(auditTarget, returnValue, exception, requestContext);
                    break;
                }
                case 1: {
                    AuthenticationTransaction authenticationTransaction = (AuthenticationTransaction)object2;
                    String string = this.getPrincipalFromAuthenticationTransaction(authenticationTransaction);
                    break;
                }
                case 2: {
                    SingleLogoutExecutionRequest sloRequest = (SingleLogoutExecutionRequest)object2;
                    String string = this.getPrincipalFromSingleLogoutRequest(auditTarget, returnValue, exception, sloRequest);
                    break;
                }
                case 3: {
                    Authentication authentication = (Authentication)object2;
                    String string = this.getPrincipalFromAuthentication(auditTarget, returnValue, exception, authentication);
                    break;
                }
                case 4: {
                    AuthenticationResult authenticationResult = (AuthenticationResult)object2;
                    String string = this.getPrincipalFromAuthenticationResult(auditTarget, returnValue, exception, authenticationResult);
                    break;
                }
                case 5: {
                    AuditableContext auditableContext = (AuditableContext)object2;
                    String string = this.getPrincipalFromAuditContext(auditTarget, returnValue, exception, auditableContext);
                    break;
                }
                case 6: {
                    AuditableEntity auditableEntity = (AuditableEntity)object2;
                    String string = this.getPrincipalFromAuditableEntity(auditTarget, returnValue, exception, auditableEntity);
                    break;
                }
                case 7: {
                    Assertion assertion = (Assertion)object2;
                    String string = this.getPrincipalFromAssertion(auditTarget, returnValue, exception, assertion);
                    break;
                }
                case 8: {
                    Credential credential = (Credential)object2;
                    String string = this.getPrincipalFromCredential(auditTarget, returnValue, exception, credential);
                    break;
                }
                default: {
                    String string = currentPrincipal = "audit:unknown";
                }
            }
        }
        if (StringUtils.equals((CharSequence)currentPrincipal, (CharSequence)"audit:unknown") && returnValue != null) {
            Object object = returnValue;
            Objects.requireNonNull(object);
            Object object3 = object;
            int n = 0;
            currentPrincipal = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationAwareTicket.class, AuditableContext.class, Assertion.class}, (Object)object3, n)) {
                case 0 -> {
                    AuthenticationAwareTicket ticket = (AuthenticationAwareTicket)object3;
                    yield this.getPrincipalFromTicket(auditTarget, returnValue, exception, ticket);
                }
                case 1 -> {
                    AuditableContext auditableContext = (AuditableContext)object3;
                    yield this.getPrincipalFromAuditContext(auditTarget, returnValue, exception, auditableContext);
                }
                case 2 -> {
                    Assertion assertion = (Assertion)object3;
                    yield this.getPrincipalFromAssertion(auditTarget, returnValue, exception, assertion);
                }
                default -> "audit:unknown";
            };
        }
        return currentPrincipal;
    }

    protected String getPrincipalFromCredential(JoinPoint auditTarget, Object returnValue, Exception exception, Credential credential) {
        return (String)StringUtils.defaultIfBlank((CharSequence)credential.getId(), (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAssertion(JoinPoint auditTarget, Object returnValue, Exception exception, Assertion assertion) {
        Authentication authentication = assertion.getPrimaryAuthentication();
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAuditContext(JoinPoint auditTarget, Object returnValue, Exception exception, AuditableContext auditableContext) {
        return auditableContext.getAuthentication().map(authentication -> {
            String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
            return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
        }).or(() -> auditableContext.getPrincipal().map(Principal::getId)).orElse("audit:unknown");
    }

    protected String getPrincipalFromTicket(JoinPoint auditTarget, Object returnValue, Exception exception, AuthenticationAwareTicket ticket) {
        Authentication authentication = ticket.getAuthentication();
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAuthenticationResult(JoinPoint auditTarget, Object returnValue, Exception exception, AuthenticationResult authenticationResult) {
        Authentication authentication = authenticationResult.getAuthentication();
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAuditableEntity(JoinPoint auditTarget, Object returnValue, Exception exception, AuditableEntity entity) {
        return (String)StringUtils.defaultIfBlank((CharSequence)entity.getAuditablePrincipal(), (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAuthentication(JoinPoint auditTarget, Object returnValue, Exception exception, Authentication authentication) {
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromSingleLogoutRequest(JoinPoint auditTarget, Object returnValue, Exception exception, SingleLogoutExecutionRequest sloRequest) {
        Authentication authentication = sloRequest.getTicketGrantingTicket().getAuthentication();
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        return (String)StringUtils.defaultIfBlank((CharSequence)principalId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromAuthenticationTransaction(AuthenticationTransaction authenticationTransaction) {
        String credentialId = authenticationTransaction.getPrimaryCredential().map(Credential::getId).orElse("audit:unknown");
        return (String)StringUtils.defaultIfBlank((CharSequence)credentialId, (CharSequence)"audit:unknown");
    }

    protected String getPrincipalFromRequestContext(JoinPoint auditTarget, Object returnValue, Exception exception, RequestContext requestContext) {
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        CasWebflowCredentialProvider credentialProvider = (CasWebflowCredentialProvider)applicationContext.getBean("casWebflowCredentialProvider", CasWebflowCredentialProvider.class);
        List credentials = credentialProvider.extract(requestContext);
        String credentialId = credentials.stream().map(Credential::getId).findFirst().orElse("audit:unknown");
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        String principalId = this.auditPrincipalIdProvider.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
        String id = Optional.ofNullable(principalId).or(() -> Optional.ofNullable(authentication).map(Authentication::getPrincipal).map(Principal::getId)).orElse(credentialId);
        return (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"audit:unknown");
    }

    @Generated
    public DefaultAuditPrincipalResolver(AuditPrincipalIdProvider auditPrincipalIdProvider) {
        this.auditPrincipalIdProvider = auditPrincipalIdProvider;
    }
}

