/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionResolutionContext;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class DefaultAttributeDefinition
implements AttributeDefinition {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAttributeDefinition.class);
    private static final long serialVersionUID = 6898745248727445565L;
    private String key;
    private String name;
    private boolean scoped;
    private boolean encrypted;
    private String attribute;
    private String patternFormat;
    @ExpressionLanguageCapable
    private String script;
    private String canonicalizationMode;
    private Map<String, String> patterns;
    private String flattened;

    private static List<Object> formatValuesWithScope(String scope, List<Object> currentValues) {
        return currentValues.stream().map(value -> String.format("%s@%s", value, scope)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Object> encryptValues(List<Object> currentValues, RegisteredService registeredService) {
        RegisteredServicePublicKey publicKey = registeredService.getPublicKey();
        if (publicKey == null) {
            LOGGER.error("No public key is defined for service [{}]. No attributes will be released", (Object)registeredService);
            return new ArrayList<Object>(0);
        }
        Cipher cipher = publicKey.toCipher();
        if (cipher == null) {
            LOGGER.error("Unable to initialize cipher given the public key algorithm [{}]", (Object)publicKey.getAlgorithm());
            return new ArrayList<Object>(0);
        }
        return currentValues.stream().map(Unchecked.function(value -> {
            LOGGER.trace("Encrypting attribute value [{}]", value);
            String result = EncodingUtils.encodeBase64((byte[])cipher.doFinal(value.toString().getBytes(StandardCharsets.UTF_8)));
            LOGGER.trace("Encrypted attribute value [{}]", (Object)result);
            return result;
        })).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Object> fetchAttributeValueFromExternalGroovyScript(String attributeName, List<Object> currentValues, String file, AttributeDefinitionResolutionContext context) throws Throwable {
        Optional result = ApplicationContextProvider.getScriptResourceCacheManager();
        if (result.isPresent()) {
            ScriptResourceCacheManager cacheMgr = (ScriptResourceCacheManager)result.get();
            ExecutableCompiledGroovyScript script = cacheMgr.resolveScriptableResource(file, new String[]{attributeName, file});
            if (script != null) {
                return DefaultAttributeDefinition.fetchAttributeValueFromScript(script, attributeName, currentValues, context);
            }
        }
        LOGGER.warn("No groovy script cache manager is available to execute attribute mappings");
        return new ArrayList<Object>(0);
    }

    private static List<Object> fetchAttributeValueAsInlineGroovyScript(String attributeName, List<Object> currentValues, String inlineGroovy, AttributeDefinitionResolutionContext context) {
        return ApplicationContextProvider.getScriptResourceCacheManager().map(cacheManager -> (List)FunctionUtils.doUnchecked(() -> {
            ExecutableCompiledGroovyScript script = cacheManager.resolveScriptableResource(inlineGroovy, new String[]{attributeName, inlineGroovy});
            return DefaultAttributeDefinition.fetchAttributeValueFromScript(script, attributeName, currentValues, context);
        })).orElseGet(() -> {
            LOGGER.warn("No groovy script cache manager is available to execute attribute mappings");
            return new ArrayList(0);
        });
    }

    private static List<Object> fetchAttributeValueFromScript(ExecutableCompiledGroovyScript scriptToExec, String attributeKey, List<Object> currentValues, AttributeDefinitionResolutionContext context) throws Throwable {
        Map args = CollectionUtils.wrap((String)"attributeName", (Object)Objects.requireNonNull(attributeKey), (String)"attributeValues", currentValues, (String)"logger", (Object)LOGGER, (String)"registeredService", (Object)context.getRegisteredService(), (String)"attributes", (Object)context.getAttributes());
        scriptToExec.setBinding(args);
        return (List)scriptToExec.execute(args.values().toArray(), List.class);
    }

    public int compareTo(AttributeDefinition o) {
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).build();
    }

    @JsonIgnore
    public List<Object> resolveAttributeValues(AttributeDefinitionResolutionContext context) throws Throwable {
        List<Object> currentValues = new ArrayList<Object>(context.getAttributeValues());
        if (StringUtils.isNotBlank((CharSequence)this.getScript())) {
            currentValues = this.getScriptedAttributeValue(this.key, currentValues, context);
        }
        if (this.getPatterns() != null && !this.getPatterns().isEmpty() && !currentValues.isEmpty()) {
            currentValues = this.getPatternValuesFor(currentValues, context);
        }
        if (this.isScoped()) {
            currentValues = DefaultAttributeDefinition.formatValuesWithScope(context.getScope(), currentValues);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPatternFormat())) {
            currentValues = this.formatValuesWithPattern(currentValues);
        }
        if (this.isEncrypted()) {
            currentValues = DefaultAttributeDefinition.encryptValues(currentValues, context.getRegisteredService());
        }
        if (StringUtils.isNotBlank((CharSequence)this.canonicalizationMode)) {
            CaseCanonicalizationMode mode = CaseCanonicalizationMode.valueOf((String)this.canonicalizationMode.toUpperCase(Locale.ENGLISH));
            currentValues = Objects.requireNonNull(currentValues).stream().map(value -> mode.canonicalize(value.toString())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFlattened()) && currentValues.size() > 1) {
            String flattenedValue = currentValues.stream().map(Object::toString).collect(Collectors.joining(this.getFlattened()));
            currentValues.clear();
            currentValues.add(flattenedValue);
        }
        LOGGER.trace("Resolved values [{}] for attribute definition [{}]", currentValues, (Object)this);
        return currentValues;
    }

    private List<Object> getPatternValuesFor(List<Object> currentValues, AttributeDefinitionResolutionContext context) {
        return this.patterns.entrySet().stream().map(entry -> {
            Pattern pattern = RegexUtils.createPattern((String)((String)entry.getKey()));
            return currentValues.stream().filter(value -> RegexUtils.find((Pattern)pattern, (String)value.toString())).map(value -> DefaultAttributeDefinition.getScriptedPatternedValue(value, (String)entry.getValue(), context)).findFirst().orElse("");
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private List<Object> formatValuesWithPattern(List<Object> currentValues) {
        return currentValues.stream().map(value -> MessageFormat.format(this.getPatternFormat(), value)).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<Object> getScriptedAttributeValue(String attributeKey, List<Object> currentValues, AttributeDefinitionResolutionContext context) throws Throwable {
        LOGGER.trace("Locating attribute value via script for definition [{}]", (Object)this);
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.getScript());
        if (matcherInline.find()) {
            return DefaultAttributeDefinition.fetchAttributeValueAsInlineGroovyScript(attributeKey, currentValues, matcherInline.group(1), context);
        }
        String scriptDefinition = SpringExpressionLanguageValueResolver.getInstance().resolve(this.getScript());
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)scriptDefinition);
        if (matcherFile.find()) {
            return DefaultAttributeDefinition.fetchAttributeValueFromExternalGroovyScript(attributeKey, currentValues, matcherFile.group(), context);
        }
        return new ArrayList<Object>(0);
    }

    private static String getScriptedPatternedValue(Object currentValue, String patternedValue, AttributeDefinitionResolutionContext context) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)patternedValue);
        if (matcherInline.find()) {
            return ApplicationContextProvider.getScriptResourceCacheManager().map(cacheManager -> (String)FunctionUtils.doUnchecked(() -> {
                ExecutableCompiledGroovyScript script = cacheManager.resolveScriptableResource(patternedValue, new String[0]);
                Map args = CollectionUtils.wrap((String)"context", (Object)context, (String)"currentValue", (Object)currentValue, (String)"logger", (Object)LOGGER);
                script.setBinding(args);
                return (String)script.execute(args.values().toArray(), String.class);
            })).orElse(patternedValue);
        }
        return patternedValue;
    }

    @Generated
    private static Map<String, String> $default$patterns() {
        return new LinkedHashMap<String, String>();
    }

    @Generated
    protected DefaultAttributeDefinition(DefaultAttributeDefinitionBuilder<?, ?> b) {
        this.key = b.key;
        this.name = b.name;
        this.scoped = b.scoped;
        this.encrypted = b.encrypted;
        this.attribute = b.attribute;
        this.patternFormat = b.patternFormat;
        this.script = b.script;
        this.canonicalizationMode = b.canonicalizationMode;
        this.patterns = b.patterns$set ? b.patterns$value : DefaultAttributeDefinition.$default$patterns();
        this.flattened = b.flattened;
    }

    @Generated
    public static DefaultAttributeDefinitionBuilder<?, ?> builder() {
        return new DefaultAttributeDefinitionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DefaultAttributeDefinition(key=" + this.key + ", name=" + this.name + ", scoped=" + this.scoped + ", encrypted=" + this.encrypted + ", attribute=" + this.attribute + ", patternFormat=" + this.patternFormat + ", script=" + this.script + ", canonicalizationMode=" + this.canonicalizationMode + ", patterns=" + String.valueOf(this.patterns) + ", flattened=" + this.flattened + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAttributeDefinition)) {
            return false;
        }
        DefaultAttributeDefinition other = (DefaultAttributeDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultAttributeDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isScoped() {
        return this.scoped;
    }

    @Generated
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Generated
    public String getAttribute() {
        return this.attribute;
    }

    @Generated
    public String getPatternFormat() {
        return this.patternFormat;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public String getCanonicalizationMode() {
        return this.canonicalizationMode;
    }

    @Generated
    public Map<String, String> getPatterns() {
        return this.patterns;
    }

    @Generated
    public String getFlattened() {
        return this.flattened;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setScoped(boolean scoped) {
        this.scoped = scoped;
    }

    @Generated
    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    @Generated
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Generated
    public void setPatternFormat(String patternFormat) {
        this.patternFormat = patternFormat;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setCanonicalizationMode(String canonicalizationMode) {
        this.canonicalizationMode = canonicalizationMode;
    }

    @Generated
    public void setPatterns(Map<String, String> patterns) {
        this.patterns = patterns;
    }

    @Generated
    public void setFlattened(String flattened) {
        this.flattened = flattened;
    }

    @Generated
    public DefaultAttributeDefinition(String key, String name, boolean scoped, boolean encrypted, String attribute, String patternFormat, String script, String canonicalizationMode, Map<String, String> patterns, String flattened) {
        this.key = key;
        this.name = name;
        this.scoped = scoped;
        this.encrypted = encrypted;
        this.attribute = attribute;
        this.patternFormat = patternFormat;
        this.script = script;
        this.canonicalizationMode = canonicalizationMode;
        this.patterns = patterns;
        this.flattened = flattened;
    }

    @Generated
    public DefaultAttributeDefinition() {
        this.patterns = DefaultAttributeDefinition.$default$patterns();
    }

    @Generated
    public DefaultAttributeDefinition withKey(String key) {
        return this.key == key ? this : new DefaultAttributeDefinition(key, this.name, this.scoped, this.encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withName(String name) {
        return this.name == name ? this : new DefaultAttributeDefinition(this.key, name, this.scoped, this.encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withScoped(boolean scoped) {
        return this.scoped == scoped ? this : new DefaultAttributeDefinition(this.key, this.name, scoped, this.encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withEncrypted(boolean encrypted) {
        return this.encrypted == encrypted ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withAttribute(String attribute) {
        return this.attribute == attribute ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withPatternFormat(String patternFormat) {
        return this.patternFormat == patternFormat ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, this.attribute, patternFormat, this.script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withScript(String script) {
        return this.script == script ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, this.attribute, this.patternFormat, script, this.canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withCanonicalizationMode(String canonicalizationMode) {
        return this.canonicalizationMode == canonicalizationMode ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, this.attribute, this.patternFormat, this.script, canonicalizationMode, this.patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withPatterns(Map<String, String> patterns) {
        return this.patterns == patterns ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, patterns, this.flattened);
    }

    @Generated
    public DefaultAttributeDefinition withFlattened(String flattened) {
        return this.flattened == flattened ? this : new DefaultAttributeDefinition(this.key, this.name, this.scoped, this.encrypted, this.attribute, this.patternFormat, this.script, this.canonicalizationMode, this.patterns, flattened);
    }

    @Generated
    public static abstract class DefaultAttributeDefinitionBuilder<C extends DefaultAttributeDefinition, B extends DefaultAttributeDefinitionBuilder<C, B>> {
        @Generated
        private String key;
        @Generated
        private String name;
        @Generated
        private boolean scoped;
        @Generated
        private boolean encrypted;
        @Generated
        private String attribute;
        @Generated
        private String patternFormat;
        @Generated
        private String script;
        @Generated
        private String canonicalizationMode;
        @Generated
        private boolean patterns$set;
        @Generated
        private Map<String, String> patterns$value;
        @Generated
        private String flattened;

        @Generated
        public B key(String key) {
            this.key = key;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B scoped(boolean scoped) {
            this.scoped = scoped;
            return this.self();
        }

        @Generated
        public B encrypted(boolean encrypted) {
            this.encrypted = encrypted;
            return this.self();
        }

        @Generated
        public B attribute(String attribute) {
            this.attribute = attribute;
            return this.self();
        }

        @Generated
        public B patternFormat(String patternFormat) {
            this.patternFormat = patternFormat;
            return this.self();
        }

        @Generated
        public B script(String script) {
            this.script = script;
            return this.self();
        }

        @Generated
        public B canonicalizationMode(String canonicalizationMode) {
            this.canonicalizationMode = canonicalizationMode;
            return this.self();
        }

        @Generated
        public B patterns(Map<String, String> patterns) {
            this.patterns$value = patterns;
            this.patterns$set = true;
            return this.self();
        }

        @Generated
        public B flattened(String flattened) {
            this.flattened = flattened;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DefaultAttributeDefinition.DefaultAttributeDefinitionBuilder(key=" + this.key + ", name=" + this.name + ", scoped=" + this.scoped + ", encrypted=" + this.encrypted + ", attribute=" + this.attribute + ", patternFormat=" + this.patternFormat + ", script=" + this.script + ", canonicalizationMode=" + this.canonicalizationMode + ", patterns$value=" + String.valueOf(this.patterns$value) + ", flattened=" + this.flattened + ")";
        }
    }

    @Generated
    private static final class DefaultAttributeDefinitionBuilderImpl
    extends DefaultAttributeDefinitionBuilder<DefaultAttributeDefinition, DefaultAttributeDefinitionBuilderImpl> {
        @Generated
        private DefaultAttributeDefinitionBuilderImpl() {
        }

        @Override
        @Generated
        protected DefaultAttributeDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DefaultAttributeDefinition build() {
            return new DefaultAttributeDefinition(this);
        }
    }
}

