/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ReturnRestfulAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnRestfulAttributeReleasePolicy.class);
    private static final long serialVersionUID = -6249488544306639050L;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().singleValueAsArray(true).build().toObjectMapper();
    private String endpoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        HttpResponse response = null;
        try {
            try (StringWriter writer = new StringWriter();){
                MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, attributes);
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.POST).url(this.endpoint).parameters(CollectionUtils.wrap((String)"principal", (Object)context.getPrincipal().getId(), (String)"service", (Object)context.getRegisteredService().getServiceId())).entity(writer.toString()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).build();
                response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    LOGGER.debug("Policy response received: [{}]", (Object)result);
                    Map map = (Map)MAPPER.readValue(JsonValue.readHjson((String)result).toString(), (TypeReference)new TypeReference<Map<String, List<Object>>>(){});
                    HttpUtils.close((HttpResponse)response);
                    return map;
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new HashMap<String, List<Object>>(0);
    }

    @Override
    @Generated
    public String toString() {
        return "ReturnRestfulAttributeReleasePolicy(super=" + super.toString() + ", endpoint=" + this.endpoint + ")";
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnRestfulAttributeReleasePolicy)) {
            return false;
        }
        ReturnRestfulAttributeReleasePolicy other = (ReturnRestfulAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$endpoint = this.endpoint;
        String other$endpoint = other.endpoint;
        return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnRestfulAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $endpoint = this.endpoint;
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        return result;
    }

    @Generated
    public ReturnRestfulAttributeReleasePolicy(String endpoint) {
        this.endpoint = endpoint;
    }
}

